<?php

namespace apexl\Io\modules\paymentDisplay\controllers;

use apexl\Config\Singleton;
use apexl\encryption\Encrypt;
use apexl\Io\includes\Controller;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\display\components\BasicLink;
use apexl\Io\modules\display\components\ColWrapper;
use apexl\Io\modules\display\components\ComponentWrapper;
use apexl\Io\modules\display\components\ContentTitle;
use apexl\Io\modules\display\components\DisplayTable;
use apexl\Io\modules\display\components\EntityDisplayTile;
use apexl\Io\modules\display\components\EntityFilteredDisplayTable;
use apexl\Io\modules\display\components\FilterForm;
use apexl\Io\modules\display\components\FormComponent;
use apexl\Io\modules\display\components\genericComponents;
use apexl\Io\modules\display\components\RowWrapper;
use apexl\Io\modules\display\services\Render;
use apexl\Io\modules\invoice\services\invoiceService;
use apexl\Io\modules\payment\entities\paymentEntity;
use apexl\Io\modules\payment\entities\paymentTokenEntity;
use apexl\Io\modules\payment\entities\userCreditEntity;
use apexl\Io\modules\payment\providers\stripeProvider;
use apexl\Io\modules\payment\services\cardValidationService;

use apexl\Io\modules\payment\services\paymentService;
use apexl\Io\modules\payment\services\woocommerceIntegrationService;
use apexl\Io\modules\paymentDisplay\components\viewTiles;
use apexl\Io\modules\subscription\entities\subscriptionEntity;
use apexl\Io\modules\subscription\services\subscriptionService;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;
use apexl\Io\modules\user\services\userTools;
use app\module\simcard\entities\simOrderEntity;
use app\module\simcard\entities\simOrderItemEntity;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class paymentTokenController extends Controller{

    protected $currentUser;

    public function __construct(currentUser $currentUser, Render $render)
    {
        parent::__construct();
        $this->currentUser = $currentUser::getCurrentUser();
        $this->render = $render;
    }

    public function paymentDetails(Request $request, Response $response, $args)
    {

        $currentUser = currentUser::getCurrentUser();
        $paymentService = new paymentService();
        $invoiceService = new invoiceService();
        $components = [];

        if($currentUser->isAllowed('ManageUsers')) {
            $filterForm = (new RowWrapper())
                ->addComponent((new FilterForm())->isShared()->src(Routes::getRoutePattern('payment.display.forms.filter-payment-details')));
            $components[] = $filterForm;
        }

        $subscriptionTable = new EntityFilteredDisplayTable();
        $subscriptionTable->src(Routes::getRoutePattern('subscription.data.basic'));
        $subscriptionTable->displayPagination(FALSE);
        $subscriptionTable->displayShortTotals(FALSE);
        //$subscriptionTable->hideIdColumn();
        if($currentUser->isAllowed('ManageUsers') || $currentUser->isAllowed('UpdateSubscriptions')) {
            $subscriptionTable->addEditButton('subscriptionEntity.display.put');
        }

        $invoicesTable = new EntityFilteredDisplayTable();
        $invoicesTable->src(Routes::getRoutePattern('invoice.data.basic'));
        $invoicesTable->displayPagination(FALSE);
        $invoicesTable->displayShortTotals(FALSE);
        $invoicesTable->hideIdColumn();

        $paymentsTable = new EntityFilteredDisplayTable();
        $paymentsTable->src(Routes::getRoutePattern('payment.data.basic'));
        $paymentsTable->displayPagination(FALSE);
        $paymentsTable->displayShortTotals(FALSE);
        $paymentsTable->hideIdColumn();

        $cardsTable = new EntityFilteredDisplayTable();
        $cardsTable->src(Routes::getRoutePattern('paymentToken.data.basic'));
        $cardsTable->displayPagination(FALSE);
        $cardsTable->displayShortTotals(FALSE);
        $cardsTable->addClass('col-12 col-lg-12 col-xl-12 mt-4');
        $cardsTable->hideIdColumn();
        $cardsTable->addEditButton('paymentTokenEntity.display.put');
        $cardsTable->addDeleteButton('paymentTokenEntity.display.delete');

        $paymentService = new paymentService();
        $button = new BasicLink();
        $button->addRoute($paymentService->getCardSetupLink($currentUser));
        $button->addText('Add New Card');
        $button->addClass('add-new-card-button btn btn-primary text-center w-100 mt-5');

        $subscriptionsTitle = new ContentTitle();
        $subscriptionsTitle->addTitle('Subscriptions');
        $invoicesTitle = new ContentTitle();
        $invoicesTitle->addTitle('Invoices');
        $invoicesTitle->addClass('mt-5');
        $paymentsTitle = new ContentTitle();
        $paymentsTitle->addTitle('Payment Attempts');
        $paymentsTitle->addClass('mt-5');
        $subscriptionsList = new ColWrapper();
        $subscriptionsList->addClass('bg-white col-7');
        $subscriptionsList->addComponent($subscriptionsTitle)->addComponent($subscriptionTable)->addComponent($invoicesTitle)->addComponent($invoicesTable)->addComponent($paymentsTitle)->addComponent($paymentsTable);

        $cardsTitle = new ContentTitle();
        $cardsTitle->addTitle('Payment Cards');
        if ($invoiceService->getTotalCredit($currentUser->id) > 0) {
            $cardsTitle->addContent("Available credit: <strong>£{$invoiceService->getTotalCredit($currentUser->id)}</strong>");
        }
        $cardsList = new ColWrapper();
        $cardsList->addClass('bg-white col-4');
        $cardsList->addComponent($cardsTitle)->addComponent($cardsTable)->addComponent($button);

        $content = (new RowWrapper())
            ->addComponent($subscriptionsList)
            ->addComponent($cardsList)
        ;

        $components[] = $content;

        $this->render::setPageTitle('Payment Details');

        return System::asJson($response, $this->render::build($components));
    }

    public function paymentAdminDashboard(Request $request, Response $response, $args)
    {
        $components = [];

        // Dates
        $start = (isset($args['startDate']) && $args['startDate']) ? \DateTime::createFromFormat('Y-m-d', $args['startDate']) . ' 00:00:00' : new \DateTime('first day of this month');
        $end = (isset($args['endDate']) && $args['endDate']) ? \DateTime::createFromFormat('Y-m-d', $args['endDate']) . ' 23:59:59' : new \DateTime('last day of this month');

        $simOrderEntity = new simOrderEntity();
        $salesFigures = $simOrderEntity->getSalesFiguresForDates($start, $end);

        $simOrderItemEntity = new simOrderItemEntity();
        $bestsellerInfo = $simOrderItemEntity->getBestsellerInfo($start, $end);

        $subscriptionService = new subscriptionService();
        $subscriptionBestseller = $subscriptionService->getBestsellerInfo($start, $end);

//print_r($subscriptionBestseller);
//print_r($bestsellerInfo);die();



        // Panel 1 - Sales
        $col1Wrapper = (new ColWrapper())->addClass('bg-white sales-summary');
        $col1Wrapper->addComponents([
            (new ContentTitle())->addTitle('Sales')->addContent('£'.number_format($salesFigures->salesTotal, 2) . '<br><small>Total Sales Between '.$start->format('jS F Y').' and '.$end->format('jS F Y').'</small>'),
            (new ContentTitle())->addTitle('Total Orders')->addContent($salesFigures->salesCount),
            (new ContentTitle())->addTitle('Average Sales per order')->addContent('£'.number_format($salesFigures->salesAverage, 2)),
        ]);
        $components[] = $col1Wrapper;

        // Panel 2 - Top product by volume
        $col2Wrapper = (new ColWrapper())->addClass('bg-white top-product-by-volume');
        $col2Wrapper->addComponents([
            (new ContentTitle())->addTitle('Top Product By Volume')->addContent($bestsellerInfo->byVolume->name),
            (new ContentTitle())->addTitle('Total Orders')->addContent((string)$bestsellerInfo->byVolume->quantity),
        ]);
        $components[] = $col2Wrapper;

        // Panel 3 - Top product by value
        $col3Wrapper = (new ColWrapper())->addClass('bg-white top-product-by-value');
        $col3Wrapper->addComponents([
            (new ContentTitle())->addTitle('Top Product By Value')->addContent($bestsellerInfo->byValue->value > $subscriptionBestseller->value ? $bestsellerInfo->byValue->name : $subscriptionBestseller->name),
            (new ContentTitle())->addTitle('Total Value')->addContent('£'.number_format($bestsellerInfo->byValue->value > $subscriptionBestseller->value ? $bestsellerInfo->byValue->value : $subscriptionBestseller->value, 2)),
        ]);
        $components[] = $col3Wrapper;

        $col4Wrapper = (new ColWrapper())->addClass('bg-white latest-payments');
        $paymentsTable = new EntityFilteredDisplayTable();
        $paymentsTable->src(Routes::getRoutePattern('payment-latest.data.basic'));
        $paymentsTable->displayPagination(FALSE);
        $paymentsTable->displayShortTotals(FALSE);
        $paymentsTable->hideIdColumn();
        $col4Wrapper->addComponent($paymentsTable);
        $components[] = $col4Wrapper;

        $this->render::setPageTitle('Admin - Payments');
        return System::asJson($response, $this->render::build($components));
    }


    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @return Response
     * @throws \Exception
     */
    public function updatePaymentToken(Request $request, Response $response, $args = []){

        $paymentTokenEntity = new paymentTokenEntity();
        $title= "";
        $components = [];

        if($id = $args[$paymentTokenEntity->primaryKey] ?? FALSE){
            $paymentTokenEntity->load($id);
            $title = 'Edit Card #'. $paymentTokenEntity->id;
            if ($this->currentUser->id == $paymentTokenEntity->user_id || $this->currentUser->isAllowed('AccessGlobalEntities')) {
                $components = (new FormComponent())->setID('updatePaymentToken')->src(Routes::getRoutePattern('payment.display.forms.update-card', $args));
            }
        }

        $this->render::setPageTitle($title);
        $this->output::addResponse($request, $this->render::build($components));
        return System::asJson($response);
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @return Response
     * @throws \Exception
     */
    public function deletePaymentToken(Request $request, Response $response, $args = []){

        $paymentTokenEntity = new paymentTokenEntity();
        $title= "";
        $components = [];

        if($id = $args[$paymentTokenEntity->primaryKey] ?? FALSE){
            $paymentTokenEntity->load($id);
            $title = 'Edit Card #'. $paymentTokenEntity->id;
            if ($this->currentUser->id == $paymentTokenEntity->user_id || $this->currentUser->isAllowed('AccessGlobalEntities') || $this->currentUser->hasRole(1)) {

                $config = Singleton::getInstance();
                $stripe = new stripeProvider();
                $encrypt = new Encrypt();

                $paymentMethodRefDecrypted = $encrypt->decrypt($paymentTokenEntity->payment_method_ref, $paymentTokenEntity->payment_method_ref_iv, $config->app->encryption->key);
                if ($paymentMethod = $stripe->getPaymentMethod($paymentMethodRefDecrypted)) {
                    $basicInfo = new DisplayTable();
                    $basicInfo->addTitle("Are you sure you want to delete this payment method?");
                    $basicInfo->addData('ID', $paymentTokenEntity->id);
                    $basicInfo->addData('Type', $paymentMethod->card->brand);
                    $basicInfo->addData('Name', $paymentTokenEntity->ref);
                    $basicInfo->addData('Description', ucfirst($paymentMethod->card->funding) . ' card ending in **** '.$paymentMethod->card->last4 . '<br>expires: '.$paymentMethod->card->exp_month.'/'.$paymentMethod->card->exp_year);
                    $components[] = $basicInfo;
                }

                $components[] = (new FormComponent())
                    ->src(Routes::getRoutePattern('payment.display.forms.delete-card', ['id' => $id]))
                    ->header(3);
                $title = 'Confirm Payment Method Deletion:';

                $components = (new RowWrapper())->addClass('delete-token-wrapper')
                    ->addComponent(genericComponents::dashboardBlockWrapper($components));

            }
        }

        $this->render::setPageTitle($title);
        $this->output::addResponse($request, $this->render::build($components));
        return System::asJson($response);
    }

}