<?php

namespace apexl\Io\modules\paymentDisplay;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Hook;
use apexl\Io\modules\display\controllers\displayController;
use apexl\Io\modules\paymentDisplay\controllers\paymentTokenController;
use apexl\Io\modules\payment\entities\paymentEntity;
use apexl\Io\modules\payment\entities\paymentTokenEntity;
use apexl\Io\modules\paymentDisplay\callbacks\boot;
use apexl\Io\modules\paymentDisplay\callbacks\userDisplay;
use apexl\Io\modules\paymentDisplay\controllers\billingController;
use apexl\Io\modules\paymentDisplay\controllers\formsController;
use apexl\Io\modules\menu\services\Menu;
use apexl\Io\modules\paymentDisplay\controllers\paymentController;
use apexl\Io\modules\userDisplay\userDisplayModule;

class paymentDisplayModule extends userDisplayModule {
    public function __construct()
    {
        parent::__construct();
    }

    public function routes()
    {
        $this->addProtectedEntityRoutes((new paymentTokenEntity()), [
            'put' => [paymentTokenController::class.':updatePaymentToken', 'ManagePayments'],
            'delete' => [paymentTokenController::class.':deletePaymentToken', 'ManagePayments'],
        ]);

        $this->addProtectedRootRoute('GET', 'payment.display.terms', 'payment/terms', paymentController::class.':prePaymentTerms');

        $this->addProtectedRootRoute('GET', 'payment.display.payment-details', 'payment-details', paymentTokenController::class.':paymentDetails', 'ManagePayments');
        $this->addProtectedRootRoute('GET', 'payment.display.payment-details-admin', 'payment-details-admin', paymentTokenController::class.':paymentAdminDashboard', 'administer');

        $this->addProtectedRootRoute('GET', 'payment.display.setup-complete', 'payment/setup-complete', paymentController::class.':setupComplete');
        $this->addProtectedRootRoute('GET', 'payment.display.threedsecure', 'payment/threedsecure/{publicId}', paymentController::class.':threeDSecure');
        $this->addProtectedRootRoute('GET', 'payment.display.threedsecure-complete', 'payment/threedsecure-complete/{publicId}', paymentController::class.':threeDSecureComplete');
        $this->addProtectedRootRoute('GET', 'payment.display.reattempt', 'reattempt/{publicId}', paymentController::class.':reattemptPayment');

        // Form routes
        $this->addProtectedFormRoute('payment.display.form.terms', 'accept-terms', formsController::class.':acceptTerms');
        $this->addProtectedFormRoute('payment.forms.admin.configuration', 'payment/forms/configuration', formsController::class.':paymentConfigurationForm', 'ManagePayments');
        $this->addProtectedFormRoute('payment.display.forms.update-card', 'payment/forms/update-card/{id}', formsController::class.':updatePaymentTokenForm', 'ManagePayments');
        $this->addProtectedFormRoute('payment.display.forms.delete-card', 'payment/forms/delete-card/{id}', formsController::class.':deletePaymentTokenForm', 'ManagePayments');
        $this->addProtectedFormRoute('payment.display.forms.filter-payment-details', 'payment/forms/filter-payment-details', formsController::class.':paymentDetailsFilterForm', 'ManagePayments');



        //admin routes
        $this->addProtectedAdminRootRoute('GET', 'payment.admin.configuration.form', 'payment/configuration', paymentController::class.':paymentSettings', 'ManagePayments');

        $this->addProtectedEntityRoutes((new paymentEntity()), [
            'all' => [displayController::class.':all', 'ManagePayments'],
            'get' => [displayController::class.':view', 'ManagePayments'],
        ]);

        //billing routes
        $this->addProtectedRootRoute('GET', 'billing.display.validationfailed', 'validation-failed/{localTokenId}', billingController::class.':validationFailed');
    }

    public function registerMenuItems(Menu $menu)
    {
        $menu::addToMenu('payment.display.parent', [
            'title' => 'Payment',
            'icon' => 'credit-card',
            'weight' => -9
        ], 'administration');

        $menu::addToMenu('paymentEntity.display.all', [
            'title' => 'Orders',
            'icon' => 'barcode-scan',
            'parent' => 'payment.display.parent',
        ], 'administration');

        $menu::addToMenu('payment.admin.configuration.form', [
            'title' => 'Payment Configuration',
            'icon' => 'credit-card-blank',
            'parent' => 'payment.display.parent',
        ], 'administration');
        $menu::addToMenu('payment.display.payment-details', [
            'title' => 'Payment Details',
            'icon' => 'receipt',
            'weight' => 0
        ]);
    }

    public function registerCallbacks(){
        Hook::registerCallback('postAuth', boot::class.':display');
        Hook::registerCallback('userDisplayAlter', userDisplay::class.':display');
        //Hook::registerCallback('displayFormRender', displayFormRender::class.':alter');
    }
}