<?php

namespace apexl\Io\modules\payment\services;

use apexl\Config\Singleton;
use apexl\encryption\Encrypt;
use apexl\Io\includes\Hook;
use apexl\Io\includes\Routes;
use apexl\Io\modules\company\entities\companyEntity;
use apexl\Io\modules\payment\entities\paymentEntity;
use apexl\Io\modules\payment\entities\paymentProviderRefEntity;
use apexl\Io\modules\payment\entities\paymentTokenEntity;
use apexl\Io\modules\payment\providers\stripeProvider;
use apexl\Io\modules\product\entities\productEntity;
use apexl\Io\modules\product\entities\productRemoteReferenceIdsEntity;
use apexl\Io\modules\subscription\entities\subscriptionEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\simService;
use apexl\Io\modules\user\services\userTools;
use apexl\Io\services\Logger;
use apexl\Io\services\Mailer;
use apexl\Io\services\Output;
use apexl\Io\services\pathUtility;
use apexl\Utils\Urls\Host;
use Psr\Http\Message\ServerRequestInterface as Request;
//use n1ghteyes\apicore\client;
use GuzzleHttp\Client;

class woocommerceIntegrationService {

    protected $config;
    
    public function __construct()
    {
        $this->config = Singleton::getInstance();
    }

    public function hasWoocommerceIntegration()
    {
        return !is_null($this->getWoocommerceApiUrl());
    }

    protected function getProductNameForId($productId)
    {
        if (!isset($productNames)) {
            static $productNames;

            $productEntity = new productEntity();
            $productNames = $productEntity->getProductNameCache();

        }

        return $productNames[$productId] ?? null;
    }

    public function createOrder($userId, $totalNet, $totalTax, $lineItems, $status, $chargeId)
    {
        $userEntity = new userEntity();
        $userEntity->load($userId);
        $prodRemoteRefIdEntity = new productRemoteReferenceIdsEntity();

        // @Todo get product cache

        $order = (object)[
            "payment_method" => "card",
            "billing" => (object)[
                "first_name" => $userEntity->first_name,
                "last_name" => $userEntity->last_name,
                "email" => $userEntity->email,
            ],
            "status" => $status,
            "line_items" => [

            ]
        ];
        if ($chargeId) $order->transaction_id = $chargeId;

        foreach ($lineItems as $item) {
            $order->line_items[] = (object)[
                "name" =>  $this->clean("Subscription payment for {$this->getProductNameForId($item->productId)} - {$item->description}"),
                "product_id" => $prodRemoteRefIdEntity->getRemoteReferenceIdByProductId($item->productId),
                "quantity" => (string)$item->quantity,
                "subtotal" => (string)($item->amount),
                "total" => (string)($item->amount),
                //"total_tax" => $item->vat,
                "tax_class" => "",
                "meta_data" => [
                    (object)[
                        'key' => "dash_subscription",
                        'value' => $item->productId
                    ]
                ]
            ];
        }

        if ($apiUrl = $this->getWoocommerceApiUrl()) {
            $response = $this->makePostRequest($apiUrl.'orders', $order);
            $order = json_decode($response);
            if (isset($order->id)) {
                return $order->id;
            }
        }

        return false;
    }

    public function fetchOrders($startDate=null, $perPage=100)
    {
        // e.g. https://example.com/wp-json/wc/v3/orders?consumer_key=ck_xxx&consumer_secret=cs_xxx&status=completed&after=2021-11-30&before=2021-12-02
        if ($webhookUrl = $this->getWoocommerceApiUrl()) {
            $queryStr = '?per_page='.$perPage.'&orderby=modified&order=asc';
            if ($startDate) $queryStr .= '&after='.$startDate;

            return $this->makeGetRequest($webhookUrl.'orders'.$queryStr);
        }
    }

    public function getUserByEmail($email)
    {
        // e.g. https://example.com/wp-json/wp/v2/users/?search=myemail@domain.com
        if ($apiUrl = $this->getWoocommerceApiUrl()) {
            $queryStr = '?email='.$email;
            $results = $this->makeGetRequest($apiUrl.'customers'.$queryStr);
            return $results[0] ?? null;
        }
    }

    protected function clean($string)
    {
        $string = trim(preg_replace('/\s\s+/', ' ', $string));
        $string = str_replace("\n", "", $string);
        return $string;
    }

    public function validateRemoteProductIds($productData)
    {
        if (!$this->hasWoocommerceIntegration()) return true;

        $productRemoteReferenceIdsEntity = new productRemoteReferenceIdsEntity();
        if (is_array($productData)) {
            foreach ($productData as $product) {
                if (!isset($product->product_id) && $product->product_id != '0') return false; // product id must be provided,  allow "0" for e.g. shipping
                if ($product->product_id > 0 && !$productRemoteReferenceIdsEntity->getProductIdUsingRemoteReferenceId($product->product_id)) return false; // No ID mapping found for woocommerce product
            }
        }

        return true;
    }

    public function setOrderStatus($orderId, $status, $tokenIv='')
    {
        if ($webhookUrl = $this->getWoocommerceWebhookUrl()) {
            $this->makeGetRequest($webhookUrl.'&order_id='.$orderId.'&status='.$status.'&dashTokenIv='.$tokenIv);
        }
    }

    public function notifyOrderSuccess($orderId, $chargeId)
    {
        if ($webhookUrl = $this->getWoocommerceWebhookUrl()) {
            $this->makeGetRequest($webhookUrl.'&order_id='.$orderId.'&charge_id='.$chargeId);
        }
    }

    protected function getWoocommerceWebhookUrl()
    {
        return $this->config->app->payments->woocommerce->webhook ?? null;
    }

    protected function getWoocommerceApiUrl()
    {
        return $this->config->app->payments->woocommerce->api_url ?? null;
    }

    protected function makeGetRequest($url)
    {
        try {
            $client = new Client(['verify' => false, 'timeout' => 10]);
            $response = $client->request('GET', $url, [
                'auth' => [
                    $this->config->app->payments->woocommerce->consumer_key,
                    $this->config->app->payments->woocommerce->consumer_secret
                ]
            ]);
            $contents = $response->getBody()->getContents();
            return json_decode($contents);
        } catch (\Exception $e){
            error_log('[WooCommerceIntegration makeGetRequest('.$url.')] FAILED - with - '.$e->getMessage());
        }
        return null;

    }

    protected function makePostRequest($url, $data)
    {
        try {

            $logData = (object)[
                'url' => $url,
                'data' => $data
            ];
            Logger::log('woocommerce_post_request', $logData);

            $client = new Client(['verify' => false]);
            $response = $client->request('POST', $url, [
                'body' => json_encode($data),
                'auth' => [
                    $this->config->app->payments->woocommerce->consumer_key,
                    $this->config->app->payments->woocommerce->consumer_secret
                ],
                'headers' => [
                    'Content-Type' => 'application/json'
                ]
            ]);
            $contents = $response->getBody()->getContents();

            $logData->response = json_decode($contents);
            Logger::log('woocommerce_post_request_response', $logData);

            return $contents;
        } catch (\Exception $e){
            echo $e->getMessage();
            $logData->error = $e->getMessage();
            Logger::log('woocommerce_post_request_error', $logData);
            error_log('[WooCommerceIntegration makePostRequest('.$url.')] FAILED - with - '.$e->getMessage());
        }

        return null;

    }

    public function orderPlacementFailureNotification($subscriptionId)
    {
        $from = $this->config->app->site->email_address ?? 'no-reply@localhost.com';
        $fromName = $this->config->app->site->name ?? 'localhost';
        $frontEndDomain = $this->config->app->site->frontend_domain ?? 'localhost';

        $mailer = new Mailer();
        $mailer->setFrom($from, $fromName);
        $mailer->addAddress('mike@developmentx.uk');     // Add a recipient
        $mailer->Subject = 'Order Creation Failure Notification';
        $mailer->Body = 'The GlobalM2MSim Dashboard failed to create an order in Woocommerce after processing Subscription ID:'.$subscriptionId;
        $mailer->IsHTML(true);
        $result = $mailer->send();

    }



    /*  NOT SURE IF THIS WILL BE NEEDED AT ALL FOR PROD - SPOTTED IT ONLINE
     public function handle(Request $request, Closure $next)
    {

        $hmac = $request->get('hmac');

        $signature = Request::header('x-wc-webhook-signature');
        $woocommerceData = $request->get('woocomerceData');
        $get_hmac = hash_hmac('sha256', $woocommerceData, $secret, true);

        $get_hmac = base64_encode($get_hmac)

        if ($hmac == $get_hmac) {
            return $next($request);
        }
        else {
            return false;
        }
    }
     */
}