<?php

namespace apexl\Io\modules\paymentDisplay\pages;

use apexl\Io\modules\display\components\defaultWrapper;
use apexl\Io\modules\display\components\ImageTile;
use apexl\Io\modules\display\components\LinkTile;
use apexl\Io\modules\display\components\RowWrapper;
use apexl\Io\modules\display\pages\blankPage;
use apexl\Io\modules\display\regions\NoUIContentRegion;
use apexl\Io\modules\display\regions\PageContentRegion;

class paymentFlow extends blankPage{
    protected function buildRegions(){
        $this->globalRegion = (new PageContentRegion())->addWrapperClass('payment-flow');
        $this->globalRegion->addRegions([
            new PageContentRegion([
                //top menu
                (new defaultWrapper())->addClass('website-top-bar')
                    ->addComponent((new RowWrapper())->resetClasses()->addClass('container')
                        //social @todo replace with variables
                        //->addComponent((new LinkTile())->addIcon('linkedin')->addRoute('')->addText('LinkedIn')->isExternal()->resetColumns()->addClass('col'))
                        //->addComponent((new LinkTile())->addIcon('facebook-official')->addRoute('')->addText('Facebook')->isExternal()->resetColumns()->addClass('col'))
                        //->addComponent((new LinkTile())->addIcon('twitter')->addRoute('')->addText('Twitter')->isExternal()->resetColumns()->addClass('col'))
                        //Spacer
                        //->addComponent((new RowWrapper())->setColWidth('lg', 5)->setColWidth('md', 3)->setColWidth('sm', 2)->addClass('d-sm-block')->addClass('d-none'))
                        //contact link
                        //->addComponent((new LinkTile())->addIcon('comment')->addRoute('https://{site_url}}/contact-us')->addText('Contact Us')->isExternal()->resetColumns()->addClass('col')),
                    ),
                //Main menu area
                (new RowWrapper())->addClass('website-menu-wrapper')
                    ->addComponent((new ImageTile())->src($this->config->app->site->logoUrl))
            ])
        ]);
    }

    /**
     * @param $component
     * @param null $weight
     * @return paymentFlow
     */
    public function addToContent($component, $weight = null){
        $this->addToRegion($component, NoUIContentRegion::class, $weight);
        return $this;
    }
}