<?php

namespace apexl\Io\modules\payment\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Hook;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\includes\Utils;
use apexl\Io\modules\payment\entities\paymentTokenEntity;
use apexl\Io\modules\payment\services\cardValidationService;
use apexl\Io\modules\payment\services\paymentService;
use apexl\Io\modules\payment\services\webhookService;
use apexl\Io\modules\user\entities\userEntity;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class webhookController extends Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    public function processRequest(Request $request, Response $response)
    {
        $webhookService = new webhookService();
        $error = $webhookService->processRequest();

        if ($error) {
            return System::asJson($response, ['error' => $error], 400);
        }

        return System::asJson($response);
    }
}
