<?php

namespace apexl\Io\modules\payment;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Hook;
use apexl\Io\includes\System;
use apexl\Io\modules\display\controllers\displayController;
use apexl\Io\modules\payment\controllers\billingController;
use apexl\Io\modules\payment\controllers\paymentController;
use apexl\Io\modules\payment\callbacks\userLoginCallback;
use apexl\Io\modules\payment\controllers\paymentTokenController;
use apexl\Io\modules\payment\controllers\webhookController;
use apexl\Io\modules\payment\entities\paymentEntity;
use apexl\Io\modules\payment\entities\paymentTokenEntity;
use apexl\Io\modules\user\classes\userManagedApiModule;
use apexl\Io\modules\user\services\Permissions;
use apexl\Io\modules\payment\callbacks\entityStoreCallback;

class paymentModule extends userManagedApiModule {
    public function __construct()
    {
        parent::__construct();
    }

    public function routes()
    {
        $this->addProtectedActionRoute('GET', 'payment.getToken', 'get-token', paymentController::class.':getToken');
        $this->addProtectedActionRoute('GET', 'payment.getToken.success', 'get-token/success/{providerSessionId}/{localTokenId}', paymentController::class.':getTokenSuccess');
        $this->addProtectedActionRoute('GET', 'payment.getToken.failure', 'get-token/failure', paymentController::class.':getTokenFailure');
        $this->addProtectedActionRoute('POST', 'payment.chargeToken', 'charge-token', paymentController::class.':chargeToken');
        $this->addProtectedActionRoute('POST', 'payment.webhook', 'webhook', webhookController::class.':processRequest', 'AllowAll');

        //$this->addProtectedActionRoute('GET', 'payment.validation.cancel', 'payment/validation/cancel', paymentController::class.':validationCancel', 'AllowAll');
        $this->addProtectedActionRoute('GET', 'payment.validation', 'payment/validation/trigger/{userEmail}[/{subscriptionCode}]', paymentController::class.':validation');
        $this->addProtectedActionRoute('GET', 'payment.validation.success', 'payment/validation/success/{providerSessionId}/{localTokenId}', billingController::class.':validationSuccess');
        $this->addProtectedActionRoute('GET', 'payment.validation.cancel', 'payment/validation/cancel/{localTokenId}', billingController::class.':validationCancel');
        $this->addProtectedActionRoute('GET', 'payment.oneoff.cancel', 'payment/oneoff/cancel/{remoteOrderId}/{providerSessionId}', paymentController::class.':oneOffPaymentCancel');
        $this->addProtectedActionRoute('GET', 'payment.oneoff.success', 'payment/oneoff/success/{remoteOrderId}/{providerSessionId}', paymentController::class.':oneOffPaymentSuccess');

        $this->addProtectedActionRoute('POST', 'payment.terms.accept', 'payment/terms/accept', paymentController::class.':paymentTermsAccept');
        $this->addProtectedActionRoute('POST', 'payment.configuration.store', 'payment/forms/configuration/store', paymentController::class.':paymentConfigurationStore', 'ManagePayments');
        $this->addProtectedActionRoute('POST', 'payment.token.complete', 'payment/token/complete', paymentController::class.':completeSetup', 'ManagePayments');
        $this->addProtectedActionRoute('POST', 'payment.token.edit', 'payment/token/edit/', paymentTokenController::class.':updatePaymentToken', 'ManagePayments');
        $this->addProtectedActionRoute('POST', 'payment.token.delete', 'payment/token/delete/', paymentTokenController::class.':deletePaymentToken', 'ManagePayments');
        //$this->addProtectedActionRoute('POST', 'payment.token.charge', 'payment/token/charge', paymentController::class.':chargeToken', 'CreatePayments');

        //Billing Routes.
        //$this->addProtectedActionRoute('GET', 'payment.trigger.cron', 'payment/trigger/{cronKey}', paymentController::class.':triggerPayments');
        $this->addProtectedActionRoute('GET', 'billing.validation', 'payment/validation', billingController::class.':validation');

        $this->addProtectedActionRoute('POST', 'billing.validation.activate', 'payment/validation/activate', paymentController::class.':validationActivate');

        $this->addProtectedActionRoute('put', 'payment.remote.update', 'remote-update', paymentController::class.':remoteUpdate');

        // Data Routes
        $this->addProtectedDataRoute('get', 'paymentToken.data.basic', 'payment-token/data/basic', paymentTokenController::class.':paymentTokenListTableDataBasic', 'ManagePayments');
        $this->addProtectedDataRoute('get', 'payment.data.basic', 'payment/data/basic', paymentController::class.':paymentListTableDataBasic', 'ManagePayments');
        $this->addProtectedDataRoute('get', 'payment-latest.data.basic', 'payment-latest/data/basic', paymentController::class.':latestPaymentsTableData', 'ManagePayments');


        #admin routes
        $this->addProtectedEntityRoutes(new paymentEntity(), [
            'get' => [Controller::class.':get', 'ManagePayments'],
        ]);
    }
    
    /**
     * Provide the install modules Schema.
     * @return mixed|void
     */
    public function schema(){
        return System::loadSchema(__DIR__.'/schema/schema.json');
    }

    /**
     * Install method
     * @return bool|void
     * @throws \Exception
     */
    public function install()
    {
        
    }

    /**
     * Register Hook Callbacks.
     */
    public function registerCallbacks(){
        Hook::registerCallback('userLogin', userLoginCallback::class.':completeActivation');
        Hook::registerCallback('userLogin', userLoginCallback::class.':displayPaymentNotifications');
        Hook::registerCallback('preEntityInsert', entityStoreCallback::class.':insert');
    }
    
    public function registerPermissions(Permissions $permissions){
        $permissions->registerPermission('CreatePayments', 'Create Payments', 'Payments');
        $permissions->registerPermission('ViewPayments', 'View Payments', 'Payments');
        $permissions->registerPermission('ManagePayments', 'Manage Payments', 'Payments');
    }
}