<?php
namespace apexl\Io\modules\paymentDisplay\controllers;

use apexl\Config\Singleton;
use apexl\Io\includes\Controller;
use apexl\Io\includes\System;
use apexl\Io\modules\display\components\ContentTitle;
use apexl\Io\modules\display\components\RowWrapper;
use apexl\Io\modules\display\services\Render;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class billingController extends Controller
{
    protected $render;

    public function __construct(Render $render)
    {
        parent::__construct();
        $this->render = $render;
        $this->config = Singleton::getInstance();
    }

    public function validationFailed(Request $request, Response $response, $args)
    {
        // Password Creation Form page to collect
        $this->render::setActive("paymentFlow");
        $this->render::setMetaTitle("Payment Validation Failed | ". ($this->config->app->defaultMetaTitle ?? "Io Dashboard"));

        $validationFailedTitle = System::getVariable('io_payment_validation_failed_title') ?? 'Payment method was not successfully validated:';
        $validationFailedContent = System::getVariable('io_payment_validation_failed_content') ?? 'Your payment card could not be validated. If you wish to proceed please restart the process.';

        $wrapper = (new RowWrapper())->resetClasses()->addClass('payment-terms-wrapper')->addClass('container')
            ->addComponent( (new ContentTitle())
                ->addTitle($validationFailedTitle)
                ->addContent($validationFailedContent));

        $this->output::addResponse($request, $this->render::build([$wrapper]));

        return System::asJson($response);
    }
}