<?php

namespace apexl\Io\modules\payment\entities;

use apexl\Io\includes\Entity;
use apexl\Io\includes\System;
use apexl\Io\includes\Utils;
use apexl\Io\modules\payment\entities\operators\paymentOperator;

class paymentEntity extends Entity{


    public function __construct()
    {
        parent::__construct('payment');
        $this->setOperator(new paymentOperator('payment'));
    }

    protected function fieldConfig(){
        return [
            "id" => [
                'name' => "ID"
            ],
            "provider" => [
                'name' => "Payment Gateway",
            ],
            "provider_ref" => [
                'name' => "Payment Reference",
            ],
            "payment_token_id" => [
                'name' => "Token ID",
                'display' => function($date){
                    return Utils::HIDE_FROM_DISPLAY;
                }
            ],
            "amount" => [
                'name' => "Amount",
            ],
            "status" => [
                'name' => "Payment Status",
            ],
            "remote_order_id" => [
                'name' => "Order ID",
            ],
            "user_notified" => [
                'name' => "User Notified",
                'display' => function($notified){
                    return $notified ? 'Yes' : 'No';
                }
            ],
            "ref" => [
                'name' => "ref",
                'display' => function($date){
                    return Utils::HIDE_FROM_DISPLAY;
                }
            ],
            "created_by" => [
                'name' => "Created By",
                'display' => function($uid){
                    return Utils::HIDE_FROM_DISPLAY;
                }
            ],
            "modified" => [
                'name' => "Modified",
                'display' => function($date){
                    return Utils::HIDE_FROM_DISPLAY;
                }
            ],
            "modified_by" => [
                'name' => "Modified By",
                'display' => function($uid){
                    return Utils::HIDE_FROM_DISPLAY;
                }
            ],
            "data" => [
                'name' => "Data",
                'display' => function($uid){
                    return Utils::HIDE_FROM_DISPLAY;
                }
            ],
            "public_id" => [
                'name' => "Public ID",
                'display' => function($uid){
                    return Utils::HIDE_FROM_DISPLAY;
                }
            ],
            "threedsecure_url" => [
                'name' => "threedsecure_url",
                'display' => function($uid){
                    return Utils::HIDE_FROM_DISPLAY;
                }
            ],
        ];
    }
}