<?php

namespace apexl\Io\modules\payment\providers;

use apexl\Config\Singleton;
use apexl\Io\modules\payment\entities\paymentLogEntity;
use Stripe\Checkout\Session;
use Stripe\Stripe;
use Stripe\StripeClient;
use Stripe\Event;
use Stripe\Webhook;

class gocardlessProvider implements providerInterface {

    protected $config;
    protected $gocardless;

    public function __construct()
    {
        $this->config = Singleton::getInstance();

        if ($this->config->app->payments->gocardless->env == 'live') {
            $this->gocardless = new \GoCardlessPro\Client([
                'access_token' => $this->config->app->payments->gocardless->access_token,
                'environment' => \GoCardlessPro\Environment::LIVE
            ]);
        } else {
            $this->gocardless = new \GoCardlessPro\Client([
                'access_token' => $this->config->app->payments->gocardless->access_token,
                'environment' => \GoCardlessPro\Environment::SANDBOX
            ]);
        }
    }

    public function getMandateStatus($mandateId){
        return $this->gocardless->mandates()->get($mandateId)->status ?? null;
    }

    public function getCardValidationUrl($successUrl, $cancelUrl, $localTokenId, $customerRef, $meta)
    {

    }

    public function retrieveToken($sessionId)
    {

    }

    public function attachCustomerToPaymentMethod($paymentMethodId, $email, $fullName, $customerId)
    {

    }

    public function capturePaymentWithToken($paymentMethodId, $customerRef=null, $amount=0, $description = '', $currency='gbp', $data=null, $metaData=null, $transactionData, $threeDSecureReturnUrl=null)
    {

    }


}