<?php

namespace apexl\Io\modules\paymentDisplay\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\checkboxField;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\formbuilder\includes\textareaField;
use apexl\Io\modules\payment\entities\paymentTokenEntity;
use apexl\Io\modules\user\services\currentUser;
use app\module\billing\entities\billingConfigurationEntity;
use app\module\simcard\entities\simcardEntity;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class formsController extends Controller
{

    public function __construct()
    {
        parent::__construct();
    }

    public function updatePaymentTokenForm(Request $request, Response $response, $args){

        $paymentToken = new paymentTokenEntity();
        $paymentToken->load($args['id']);

        $form = new formEntity();
        $form->setId('UpdateToken');
        $form->setMethod('post');
        $form->setActionUrl(Routes::getRoutePattern('payment.token.edit'));
        $form->setSubmitText('Save');
        $form->addField((new inputField('ref'))->setLabel("Card nickname")->addClass('col')->setValue($paymentToken->ref));
        $form->addField((new checkboxField('default_token'))->setLabel("Set as default card?")->addClass('col')->setValue($paymentToken->default_token ? TRUE : FALSE));
        $form->addField((new inputField("tokenId"))->setValue($paymentToken->id ?? "")->setInputType('hidden'));
        return System::asJson($response, $form->getBuiltFormArray());
    }

    public function deletePaymentTokenForm(Request $request, Response $response, $args){

        $paymentToken = new paymentTokenEntity();
        $paymentToken->load($args['id']);

        $form = new formEntity();
        $form->setId('DeleteToken');
        $form->setMethod('post');
        $form->setActionUrl(Routes::getRoutePattern('payment.token.delete'));
        $form->setSubmitText('Delete Now');
        $form->addField((new inputField("tokenId"))->setValue($paymentToken->id ?? "")->setInputType('hidden'));
        return System::asJson($response, $form->getBuiltFormArray());
    }

    public function paymentConfigurationForm(Request $request, Response $response){
        $form = new formEntity();
        $form->setId('paymentConfig');
        $form->setMethod('post');
        $form->setActionUrl(Routes::getRoutePattern('payment.configuration.store'));

        $form->addField((new textareaField('io_payment_terms'))->setLabel('Short Terms')->setRows(5)->setValue(System::getVariable('io_payment_terms') ?? '')->enableWysiwyg());
        $form->addFieldToGroup((new inputField('io_payment_terms_link_text'))->setLabel('Link Text')->setValue(System::getVariable('io_payment_terms_link_text') ?? '')->addClass('col'), 'link');
        $form->addFieldToGroup((new inputField('io_payment_terms_link'))->setLabel('Link to full terms')->setValue(System::getVariable('io_payment_terms_link') ?? '')->addClass('col'), 'link');
        //$form->addFieldGroupClasses('link', 'wrapped-group');

        $this->output::addResponse($request, $form->getBuiltFormArray());
        return System::asJson($response);
    }

    public function acceptTerms(Request $request, Response $response)
    {
        $body = (object)$request->getQueryParams();
        if($body->args ?? FALSE) {
            $form = new formEntity();
            $form->setId('AcceptTermsForm');
            $form->setMethod('post');
            $form->setActionUrl(Routes::getRoutePattern('payment.terms.accept'));
            $form->setSubmitText('Continue');
            $form->addField((new checkboxField('acceptTerms'))->setLabel("I have read and agree to the terms and conditions"));

            // Hidden fields
            $form->addField((new inputField("args"))->setValue($body->args)->setInputType('hidden'));

            return System::asJson($response, $form->getBuiltFormArray());
        }
        return $this->throw404($response);
    }

    public function paymentDetailsFilterForm(Request $request, Response $response, $args){

        $form = new formEntity();
        $form->setId('filter-payment-details');
        $form->addClass('filter-form');
        $form->setMethod('post');
        $form->setActionUrl('#');
        $form->setSubmitText('Filter');
        $form->includeClearButton(TRUE)->setClearButtonText('Reset');
        //$form->setMethod('post');
        //$form->setActionUrl(Routes::getRoutePattern('payment.token.edit'));
        $form->addField((new inputField('userEmail'))->setLabel("Customer Email")->addClass('col'));

        return System::asJson($response, $form->getBuiltFormArray());
    }

}