<?php
namespace apexl\Io\modules\paymentDisplay\controllers;

use apexl\Config\Singleton;
use apexl\Io\includes\Controller;
use apexl\Io\includes\System;
use apexl\Io\modules\display\components\ContentTitle;
use apexl\Io\modules\display\components\RowWrapper;
use apexl\Io\modules\display\services\Render;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class billingController extends Controller
{
    protected $render;

    public function __construct(Render $render)
    {
        parent::__construct();
        $this->render = $render;
        $this->config = Singleton::getInstance();
    }

    public function validationFailed(Request $request, Response $response, $args)
    {
        // Password Creation Form page to collect
        $this->render::setActive("paymentFlow");
        $this->render::setMetaTitle("Payment Validation Failed | ". ($this->config->app->defaultMetaTitle ?? "Io Dashboard"));
        $wrapper = (new RowWrapper())->resetClasses()->addClass('payment-terms-wrapper')->addClass('container')
            ->addComponent( (new ContentTitle())
                ->addTitle('There was a problem with your payment method:')
                ->addContent('Your payment card could not be validated. Please go through the process again with a different payment method.'));

        $this->output::addResponse($request, $this->render::build([$wrapper]));

        return System::asJson($response);
    }
}