<?php

namespace apexl\Io\modules\payment\callbacks;

use apexl\Io\includes\System;
use apexl\Io\modules\payment\entities\paymentEntity;
use apexl\Io\modules\payment\entities\paymentTokenEntity;
use apexl\Io\modules\payment\services\cardValidationService;
use apexl\Io\services\Output;
use apexl\Io\services\pathUtility;
use app\module\simcard\services\simService;

class userLoginCallback {

    public static function completeActivation($match, $user, $request)
    {
        if (isset($user->id) && $user->id) {
            $paymentToken = new paymentTokenEntity();
            $latestToken = $paymentToken->getLastForUser($user->id);
            if (isset($latestToken['id'])) {
                $paymentToken->load($latestToken['id']);
                if (!$paymentToken->setup_complete && $paymentToken->validated) {
                    $cardValidation = new cardValidationService();
                    $simService = new simService();
                    $data = json_decode($paymentToken->data);
                    $iccids = [];
                    if (isset($data->iccid)) $iccids[] = $data->iccid;
                    list($firstBillingDateDate, $gracePeriodEnds) = $simService->getFirstBillingDateForIccids($iccids);
                    $createSubscription = !isset($data->subscriptionCode); // We don't want to create a new subscription if the user is adding/updating a payment method for/to an existing subscription
                    $cardValidation->comleteValidation($request, $paymentToken, $user->email, "$user->firstName $user->lastName", null, $createSubscription, $firstBillingDateDate, $gracePeriodEnds);
                    if ($createSubscription) $cardValidation->capturePaymentWithToken($user->id, $data->total, "", true, $data); // If we're creating a new subscription, capture payment immediately
                    if (isset($data->subscriptionCode)) $cardValidation->reenableUserSubscriptions($user);
                    //redirect the user if we have an external order id
                    if($data->order_complete_url ?? FALSE){
                        System::redirect($data->order_complete_url);
                    }
                }
            }
        }
    }

    public static function displayPaymentNotifications($match, $user, $request)
    {
        if (isset($user->id) && $user->id) {
            $paymentEntity = new paymentEntity();
            $notifications = $paymentEntity->getPaymentNotifications($user->id);
            if (count($notifications) > 0) {
                $output = Output::getInstance();
                $path = pathUtility::getInstance();
                foreach ($notifications as $notification) {
                    if ($notification->status == 'successful') {
                        $output::addMessage($path->getRouteName($request), 'success',"Payment of {$notification->amount} successfully processed.");
                    } else {
                        $output::addMessage($path->getRouteName($request), 'error',"Payment of {$notification->amount} failed.");
                    }
                    $paymentEntity->load($notification->id);
                    $paymentEntity->user_notified = true;
                    $paymentEntity->store();
                }
            }
        }
    }
}