<?php

namespace apexl\Io\modules\payment\entities\operators;

use apexl\Io\operators\entityDatabaseOperator;

class paymentOperator extends entityDatabaseOperator{

    public function __construct($table, $primaryKey = 'id')
    {
        parent::__construct($table, $primaryKey);
    }

    public function getPaymentNotifications($userId){
        return $this->vault
            ->select($this->dbTable)
            ->fields($this->dbTable.'.*')
            ->join('subscription_payment', 'payment_id', $this->dbTable.'.id')
            ->join('subscription', 'subscription.id', 'subscription_payment.subscription_id')
            ->where('payment.user_notified', false)
            ->where('subscription.user_id', $userId)
            ->execute()
            ->fetchAll();
    }

    public function getPendingPaymentByRemoteOrderId($remoteOrderId){
        return $this->vault
            ->select($this->dbTable)
            ->fields($this->dbTable.'.*')
            ->where('remote_order_id', $remoteOrderId)
            ->where('status', 'pending')
            ->execute()
            ->fetchAssoc();
    }

    public function getMostRecentForSubscription($subscriptionId){
        $result = $this->vault
            ->select($this->dbTable)
            ->fields($this->dbTable.'.*')
            ->join('subscription_payment', 'payment_id', $this->dbTable.'.id')
            ->join('subscription', 'subscription.id', 'subscription_payment.subscription_id')
            ->where('subscription.id', $subscriptionId)
            ->orderBy('created', 'DESC')
            ->execute()
            ->fetchAssoc();
        if ($result) {
            return (object)$result;
        }

        return null;
    }
}