<?php

namespace apexl\Io\modules\payment;

use apexl\Io\includes\Hook;
use apexl\Io\includes\System;
use apexl\Io\modules\payment\controllers\paymentController;
use apexl\Io\modules\payment\callbacks\userLoginCallback;
use apexl\Io\modules\user\classes\userManagedApiModule;
use apexl\Io\modules\user\services\Permissions;

class paymentModule extends userManagedApiModule {
    public function __construct()
    {
        parent::__construct();
    }

    public function routes()
    {
        $this->addProtectedActionRoute('GET', 'payment.getToken', 'get-token', paymentController::class.':getToken', 'AllowAll');
        $this->addProtectedActionRoute('GET', 'payment.getToken.success', 'get-token/success/{providerSessionId}/{localTokenId}', paymentController::class.':getTokenSuccess', 'AllowAll');
        $this->addProtectedActionRoute('GET', 'payment.getToken.failure', 'get-token/failure', paymentController::class.':getTokenFailure', 'AllowAll');
        $this->addProtectedActionRoute('POST', 'payment.chargeToken', 'charge-token', paymentController::class.':chargeToken', 'AllowAll');

        $this->addProtectedActionRoute('GET', 'payment.validation.cancel', 'payment/validation/cancel', paymentController::class.':validationCancel');
        $this->addProtectedActionRoute('GET', 'payment.validation', 'payment/validation/trigger/{userEmail}[/{subscriptionCode}]', paymentController::class.':validation');
        $this->addProtectedActionRoute('GET', 'payment.validation.success', 'payment/validation/success/{providerSessionId}/{localTokenId}', paymentController::class.':validationSuccess');
        $this->addProtectedActionRoute('GET', 'payment.oneoff.cancel', 'payment/oneoff/cancel/{remoteOrderId}/{providerSessionId}', paymentController::class.':oneOffPaymentCancel');
        $this->addProtectedActionRoute('GET', 'payment.oneoff.success', 'payment/oneoff/success/{remoteOrderId}/{providerSessionId}', paymentController::class.':oneOffPaymentSuccess');

        $this->addProtectedActionRoute('POST', 'payment.terms.accept', 'payment/terms/accept', paymentController::class.':paymentTermsAccept');
        $this->addProtectedActionRoute('POST', 'payment.configuration.store', 'payment/forms/configuration/store', paymentController::class.':paymentConfigurationStore', 'ManagePayments');
        $this->addProtectedActionRoute('POST', 'payment.token.complete', 'payment/token/complete', paymentController::class.':completeSetup', 'ManagePayments');
        //$this->addProtectedActionRoute('POST', 'payment.token.charge', 'payment/token/charge', paymentController::class.':chargeToken', 'CreatePayments');

        $this->addProtectedActionRoute('GET', 'payment.trigger.cron', 'payment/trigger/{cronKey}', paymentController::class.':triggerPayments', 'AllowAll');

    }
    
    /**
     * Provide the install modules Schema.
     * @return mixed|void
     */
    public function schema(){
        return System::loadSchema(__DIR__.'/schema/schema.json');
    }

    /**
     * Install method
     * @return bool|void
     * @throws \Exception
     */
    public function install()
    {
        
    }

    /**
     * Register Hook Callbacks.
     */
    public function registerCallbacks(){
        Hook::registerCallback('userLogin', userLoginCallback::class.':completeActivation');
        Hook::registerCallback('userLogin', userLoginCallback::class.':displayPaymentNotifications');
        //Hook::registerCallback('entityLoadMultipleQuery', accessControl::class.':entityLoadQuery');
        //Hook::registerCallback('entityLoadMultipleFields', accessControl::class.':entityLoadFields');
        //Hook::registerCallback('entityLoadFields', accessControl::class.':entityLoadFields');
        //Hook::registerCallback('entityLoadQuery', accessControl::class.':entityLoadQuery');
    }
    
    public function registerPermissions(Permissions $permissions){
        $permissions->registerPermission('CreatePayments', 'Create Payments', 'Payments');
        $permissions->registerPermission('ViewPayments', 'View Payments', 'Payments');
        $permissions->registerPermission('ManagePayments', 'Manage Payments', 'Payments');
    }
}