<?php

namespace apexl\Io\modules\payment\services;

use apexl\Config\Singleton;
use apexl\encryption\Encrypt;
use apexl\Io\includes\Hook;
use apexl\Io\includes\Routes;
use apexl\Io\modules\company\entities\companyEntity;
use apexl\Io\modules\payment\entities\paymentEntity;
use apexl\Io\modules\payment\entities\paymentProviderRefEntity;
use apexl\Io\modules\payment\entities\paymentTokenEntity;
use apexl\Io\modules\payment\providers\stripeProvider;
use apexl\Io\modules\subscription\entities\subscriptionEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\simService;
use apexl\Io\modules\user\services\userTools;
use apexl\Io\services\Mailer;
use apexl\Io\services\Output;
use apexl\Io\services\pathUtility;
use Psr\Http\Message\ServerRequestInterface as Request;

class paymentService {

    protected $provider;
    protected $providerName;

    public function __construct()
    {
        $this->provider = new stripeProvider();
        $this->providerName = 'stripe';
    }


    public function createPendingPayment($amount, $data=[], $remoteOrderId=0)
    {

        $payment = new paymentEntity();

        $previousPendingPayment = $payment->getPendingPaymentByRemoteOrderId($remoteOrderId);
        if (isset($previousPendingPayment['id'])) {
            $payment->load($previousPendingPayment['id']);
        }

        $payment->provider = $this->providerName;
        $payment->provider_ref = "";
        $payment->amount = $amount;
        $payment->status = "pending";
        if ($remoteOrderId) $payment->remote_order_id = $remoteOrderId;
        if ($data) $payment->data = json_encode($data);

        $payment->store();

        return $payment;
    }
}