<?php

namespace apexl\Io\modules\paymentDisplay\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\checkboxField;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\formbuilder\includes\textareaField;
use app\module\billing\entities\billingConfigurationEntity;
use app\module\simcard\entities\simcardEntity;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class formsController extends Controller
{

    public function __construct()
    {
        parent::__construct();
    }

    public function paymentConfigurationForm(Request $request, Response $response){
        $form = new formEntity();
        $form->setId('paymentConfig');
        $form->setMethod('post');
        $form->setActionUrl(Routes::getRoutePattern('payment.configuration.store'));

        $form->addField((new textareaField('io_payment_terms'))->setLabel('Short Terms')->setRows(5)->setValue(System::getVariable('io_payment_terms') ?? '')->enableWysiwyg());
        $form->addFieldToGroup((new inputField('io_payment_terms_link_text'))->setLabel('Link Text')->setValue(System::getVariable('io_payment_terms_link_text') ?? '')->addClass('col'), 'link');
        $form->addFieldToGroup((new inputField('io_payment_terms_link'))->setLabel('Link to full terms')->setValue(System::getVariable('io_payment_terms_link') ?? '')->addClass('col'), 'link');
        $form->addFieldGroupClasses('link', 'wrapped-group');

        $this->output::addResponse($request, $form->getBuiltFormArray());
        return System::asJson($response);
    }

    public function acceptTerms(Request $request, Response $response)
    {
        $body = (object)$request->getQueryParams();
        if($body->args ?? FALSE) {
            $body = json_decode(base64_decode(urldecode($body->args)));

            $form = new formEntity();
            $form->setId('AcceptTermsForm');
            $form->setMethod('post');
            $form->setActionUrl(Routes::getRoutePattern('payment.terms.accept'));
            $form->setSubmitText('Continue');
            $form->addField((new checkboxField('acceptTerms'))->setLabel("I have read and agree to the terms and conditions"));

            // Hidden fields

            $form->addField((new inputField("iccid"))->setValue($body->iccid ?? "")->setInputType('hidden'));
            $form->addField((new inputField("userEmail"))->setValue($body->userEmail ?? "")->setInputType('hidden'));
            $form->addField((new inputField("products"))->setValue($body->products ?? "")->setInputType('hidden'));
            $form->addField((new inputField("productId"))->setValue($body->productId ?? "")->setInputType('hidden'));
            $form->addField((new inputField("order_id"))->setValue($body->order_id ?? "")->setInputType('hidden'));
            $form->addField((new inputField("total"))->setValue($body->total ?? "")->setInputType('hidden'));
            $form->addField((new inputField("order_complete_url"))->setValue($body->order_complete_url ?? "")->setInputType('hidden'));

            return System::asJson($response, $form->getBuiltFormArray());
        }
        return $this->throw404($response);
    }

}