<?php

namespace apexl\Io\modules\paymentDisplay\controllers;

use apexl\Config\Singleton;
use apexl\Io\includes\Controller;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\display\components\BasicLink;
use apexl\Io\modules\display\components\ContentTitle;
use apexl\Io\modules\display\components\FormComponent;
use apexl\Io\modules\display\components\RowWrapper;
use apexl\Io\modules\display\services\Render;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class paymentController extends Controller {
    protected $render;

    public function __construct(Render $render)
    {
        parent::__construct();
        $this->render = $render;
        $this->config = Singleton::getInstance();
    }

    /**
     * @param Request $request
     * @param Response $response
     * @return Response
     */
    public function paymentSettings(Request $request, Response $response){
        //Form
        $settingsForm = (new FormComponent())->src(Routes::getRoutePattern('payment.forms.admin.configuration'));

        //render
        $this->render::setPageTitle('Payment Configuration');
        $this->output::addResponse($request, $this->render::build([$settingsForm]));
        return System::asJson($response);
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param $args
     * @return Response
     */
    public function prePaymentTerms(Request $request, Response $response, $args)
    {
        // Password Creation Form page to collect
        $this->render::setActive("paymentFlow");
        $this->render::setMetaTitle("Payment Terms | ". ($this->config->app->defaultMetaTitle ?? "Io Dashboard"));
        $wrapper = (new RowWrapper())->resetClasses()->addClass('payment-terms-wrapper')->addClass('container')->addComponent((new ContentTitle())
            ->addTitle('Terms and Conditions:')
            ->addContent(System::getVariable('io_payment_terms') ?? '')
        );
        if($termLink = System::getVariable('io_payment_terms_link')){
            $wrapper->addComponent((new BasicLink())->addRoute($termLink)->addText(System::getVariable('io_payment_terms_link_text')));        }

        $wrapper->addComponent((new FormComponent())->src(rtrim(Routes::getRoutePattern('payment.display.form.terms'),"/").'?'.http_build_query($request->getQueryParams()))
            ->addClass('accept-terms-form')->setID('accept-terms-form'));

        return System::asJson($response, $this->render::build([$wrapper]));
    }

}