<?php

namespace apexl\Io\modules\paymentDisplay;

use apexl\Io\includes\Hook;
use apexl\Io\modules\paymentDisplay\callbacks\boot;
use apexl\Io\modules\paymentDisplay\controllers\formsController;
use apexl\Io\modules\menu\services\Menu;
use apexl\Io\modules\paymentDisplay\controllers\paymentController;
use apexl\Io\modules\userDisplay\userDisplayModule;

class paymentDisplayModule extends userDisplayModule {
    public function __construct()
    {
        parent::__construct();
    }

    public function routes()
    {
        $this->addProtectedRootRoute('GET', 'payment.display.terms', 'payment/terms', paymentController::class.':prePaymentTerms');

        // Form routes
        $this->addProtectedFormRoute('payment.display.form.terms', 'accept-terms', formsController::class.':acceptTerms');
        $this->addProtectedFormRoute('payment.forms.admin.configuration', 'payment/forms/configuration', formsController::class.':paymentConfigurationForm', 'ManagePayments');

        //admin routes
        $this->addProtectedAdminRootRoute('GET', 'payment.admin.configuration.form', 'payment/configuration', paymentController::class.':paymentSettings', 'ManagePayments');
    }

    public function registerMenuItems(Menu $menu)
    {
        $menu::addToMenu('payment.display.parent', [
            'title' => 'Payment',
            'icon' => 'credit-card',
            'weight' => -9
        ], 'administration');

        $menu::addToMenu('payment.admin.configuration.form', [
            'title' => 'Payment Configuration',
            'icon' => 'credit-card-blank',
            'parent' => 'payment.display.parent',
            'weight' => -10
        ], 'administration');
    }

    public function registerCallbacks(){
        Hook::registerCallback('postAuth', boot::class.':display');
        //Hook::registerCallback('addResponse', redirects::class.':redirects');
        //Hook::registerCallback('displayFormRender', displayFormRender::class.':alter');
    }
}