<?php

namespace apexl\Io\modules\product\entities\operators;

use apexl\Io\operators\entityDatabaseOperator;

class productRemoteReferenceIdsOperator extends entityDatabaseOperator{

    public function __construct($table, $primaryKey = 'id')
    {
        parent::__construct($table, $primaryKey);
    }

    public function getProductIdUsingRemoteReferenceId($remoteProductId){
        $result = $this->vault
            ->select($this->dbTable)
            ->fields($this->dbTable.'.product_id')
            ->where('product_remote_reference_id', (string)$remoteProductId)
            ->execute()
            ->fetchAssoc();

        return $result['product_id'] ?? null;
    }

    public function getRemoteReferenceIdByProductId($productId){
        $result = $this->vault
            ->select($this->dbTable)
            ->fields($this->dbTable.'.product_remote_reference_id')
            ->where('product_id', (string)$productId)
            ->execute()
            ->fetchAssoc();

        return $result['product_remote_reference_id'] ?? null;
    }
}