<?php

namespace apexl\Io\modules\productDisplay;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Hook;
use apexl\Io\modules\menu\services\Menu;
use apexl\Io\modules\product\entities\productEntity;
use apexl\Io\modules\productDisplay\controllers\productController;
use apexl\Io\modules\userDisplay\userDisplayModule;

class productDisplayModule extends userDisplayModule {
    public function __construct()
    {
        parent::__construct();
    }

    public function routes()
    {
        $this->addProtectedEntityRoutes((new productEntity()), [
            'all' => [productController::class.':list', 'ViewProducts'],
            'get' => [Controller::class.':get', 'ViewProducts'],
            'put' => [productController::class.':edit', 'ManageProducts'],
            'post' => [Controller::class.':post', 'ManageProducts'],
            'delete' => [Controller::class.':delete', 'ManageProducts'],
        ]);

        // Forms
        $this->addProtectedFormRoute('product.display.forms.createUpdate', 'productUpdate[/{id}]', productController::class.':productEditForm', 'ManageProducts');

    }

    public function registerMenuItems(Menu $menu){

    }
}