<?php

namespace apexl\Io\modules\product;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Hook;
use apexl\Io\includes\Module;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\menu\callbacks\initialiseModules;
use apexl\Io\modules\menu\callbacks\routeCallbacks;
use apexl\Io\modules\menu\entities\menuEntity;
use apexl\Io\modules\menu\entities\menuLinkEntity;
use apexl\Io\modules\menu\services\Menu;
use apexl\Io\modules\product\callbacks\entityLoadCallback;
use apexl\Io\modules\product\callbacks\entityStoreCallback;
use apexl\Io\modules\product\callbacks\saveEntityCallback;
use apexl\Io\modules\product\entities\productEntity;
use apexl\Io\modules\user\classes\userManagedApiModule;
use apexl\Io\modules\user\services\Permissions;
use apexl\Io\modules\product\callbacks\extendEntity;

class productModule extends userManagedApiModule {
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Provide the install modules Schema.
     * @return mixed|void
     */
    public function schema(){
        return System::loadSchema(__DIR__.'/schema/schema.json');
    }

    public function routes(){
        $this->addProtectedEntityRoutes((new productEntity()), [
            'get' => [Controller::class.':get', 'ViewProducts'],
            'put' => [Controller::class.':put', 'ManageProducts'],
            'post' => [Controller::class.':post', 'ManageProducts'],
            'delete' => [Controller::class.':delete', 'ManageProducts'],
        ]);

        //action routes
        //$this->addProtectedAdminActionRoute('POST', 'billing.actions.files.upload-cdr', 'files/upload-cdr', billingController::class.':uploadCDR', 'Billing');
        //$this->addProtectedAdminActionRoute('POST', 'billing.actions.billingData.process-cdr', 'files/process-cdr/{id}', billingController::class.':processCDRUpload', 'Billing');

        // data routes
        //$this->addProtectedDataRoute('GET', 'billing.data.calculations.full', 'billing/tiles/short', billingController::class.':getCalculationDataFull', 'Billing');

    }

    /**
     * Install method
     * @return bool|void
     * @throws \Exception
     */
    public function install()
    {
        
    }

    /**
     * Register Hook Callbacks.
     */
    public function registerCallbacks(){
        Hook::registerCallback('preEntityUpdate', entityStoreCallback::class.':update');
        Hook::registerCallback('preEntityInsert', entityStoreCallback::class.':insert');
        Hook::registerCallback('entityLoadMultipleQuery', entityLoadCallback::class.':loadQuery');
        Hook::registerCallback('entityLoadMultipleFields', entityLoadCallback::class.':loadFields');
        Hook::registerCallback('entityLoadQuery', entityLoadCallback::class.':loadQuery');
        Hook::registerCallback('entityLoadFields', entityLoadCallback::class.':loadFields');
    }
    
    public function registerPermissions(Permissions $permissions){
        $permissions->registerPermission('ManageProducts', 'Manage Products', 'Products');
        $permissions->registerPermission('ViewProducts', 'View Products', 'Products');
    }
}