<?php

declare(strict_types=1);

namespace apexl\Utils\Json;

use JsonException;

class Json
{
    public static function isJson($value)
    {
        if (is_string($value)) {
            try {
                return json_decode($value, null, 512, JSON_THROW_ON_ERROR);
            } catch (JsonException $e) {
                return null;
            }
        }

        return null;
    }
}
