<?php

namespace apexl\Io\modules\product\entities\operators;

use apexl\Io\operators\entityDatabaseOperator;

class productOperator extends entityDatabaseOperator{

    public function __construct($table, $primaryKey = 'id')
    {
        parent::__construct($table, $primaryKey);
    }

    public function loadByName($productName){
        $entity = $this->vault->select($this->dbTable)->fields()->where('product_name', $productName)->execute()->fetchAssoc();
        return ['updateEntityData' => true, 'data' => $entity];
    }

    public function getProductNameCache(){
        $rows = $this->vault
            ->select($this->dbTable)
            ->fields($this->dbTable.'.*')
            ->execute()
            ->fetchAll();

        $productNames = [];
        foreach ($rows as $row) {
            $productNames[$row->id] = $row->product_name;
        }

        return $productNames;
    }

    public function getProductCacheByWPID(){
        $rows = $this->vault
            ->select($this->dbTable)
            ->fields($this->dbTable.'.*')
            ->execute()
            ->fetchAll();

        $cache = [];
        foreach ($rows as $row) {
            $cache[$row->code] = $row;
        }

        return $cache;
    }

    public function getAll(){
        return $this->vault
            ->select($this->dbTable)
            ->fields($this->dbTable.'.*')
            ->execute()
            ->fetchAll();
    }

}