<?php

namespace apexl\Io\modules\productDisplay\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\display\components\ColWrapper;
use apexl\Io\modules\display\components\EntityDisplayTable;
use apexl\Io\modules\display\components\FormComponent;
use apexl\Io\modules\display\components\RowWrapper;
use apexl\Io\modules\display\components\TableButton;
use apexl\Io\modules\display\services\Render;
use apexl\Io\modules\product\entities\productEntity;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;
use apexl\Io\modules\productDisplay\components\primaryButtons;

class productController extends Controller{
    protected $render;

    public function __construct(Render $render)
    {
        parent::__construct();
        $this->render = $render;
    }

    public function list(Request $request, Response $response)
    {
        $this->render::setPageTitle('Products');
        $rowWrapper =
            (new RowWrapper())
                ->addComponent(
                    (new ColWrapper())->setColWidth('md', 8)->addComponent(new primaryButtons())
                );

        $listTable = (new EntityDisplayTable(new productEntity()))
            ->setFilters('orderBy[]=id&orderBy[]=DESC')
            ->addViewButton('productEntity.display.get')
            ->displayShortTotals(FALSE)
            ->addEditButton('productEntity.display.put')
        ;

        $this->output::addResponse($request, $this->render::build([$rowWrapper, $listTable]));
        return System::asJson($response);
    }

    public function edit(Request $request, Response $response, $args = []){
        $title = 'Create a product';
        if($id = $args['id'] ?? FALSE){
            $productEntity = new productEntity();
            $productEntity->load($id);
            $title = 'Edit ('.$id.') '. $productEntity->getNiceName();
        }

        $form = (new FormComponent())->setID('productCreate')->src(Routes::getRoutePattern('product.display.forms.createUpdate', $args));
        $this->render::setPageTitle($title);
        $this->output::addResponse($request, $this->render::build($form));
        return System::asJson($response);
    }

    public function productEditForm()
    {

    }

}