<?php declare(strict_types=1);

namespace apexl\Io\modules\queue\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\queue\entities\queueItem;
use apexl\Vault\Vault;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

class clearQueueController extends Controller
{
    public function clear(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        Vault::getInstance()->truncate(queueItem::TABLE);

        $this->output::addMessage('queue.clear.success', 'success', 'Queue cleared');

        return System::asJson($response);
    }
}
