<?php

namespace apexl\Io\modules\queue\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\queue\entities\queueItem;
use apexl\Io\services\Output;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

class fulfillQueueController extends Controller
{
    public function fulfill(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        $uuid = $this->path->getRouteArg($request, 'uuid');
        if (!($queueItem = queueItem::fromUuid($uuid))) {
            $this->throw404($response);
            exit;
        }

        $queueItem->markFulfilled();

        Output::addMetadata('queue.fulfill.redirect', 'redirect', Routes::getRoutePattern('queue.display.display'));

        return System::asJson($response);
    }
}
