<?php declare(strict_types=1);

namespace apexl\Io\modules\queue\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\queue\entities\queueItem;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

class joinQueueController extends Controller
{
    public function add(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        $queueItem = queueItem::createFromRequest($request);

        return $this->respond(
            $response,
            'queue.add.redirect',
            Routes::getRoutePattern(
                'queue.admin.list',
                ['uuid' => $queueItem->uuid]
            )
        );
    }

    public function join(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        $queueItem = queueItem::createFromRequest($request);

        return $this->respond(
            $response,
            'queue.join.redirect',
            Routes::getRoutePattern(
                'queue.display.joined',
                ['uuid' => $queueItem->uuid]
            )
        );
    }

    private function respond(ResponseInterface $response, string $name, string $route): ResponseInterface
    {
        $this->output::addMetadata($name, 'redirect', $route);

        return System::asJson($response);
    }
}
