<?php

namespace apexl\Io\modules\queue\controllers;

use apexl\Config\Singleton;
use apexl\Io\includes\Controller;
use apexl\Io\includes\System;
use apexl\Io\modules\queue\exceptions\cronKeyException;
use apexl\Io\modules\queue\jobs\notifyLatest;
use Exception;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

class queueCronController extends Controller
{
    private const HEADER__CRON_KEY = 'X-Cron-Key';

    public function process(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        try {
            $this->assertCronKey($request);
        } catch (cronKeyException $e) {
            return System::asJson($response, ['error' => $e->getMessage()], 403);
        }

        (new notifyLatest())->handle();

        return System::asJson($response);
    }

    /**
     * @throws cronKeyException
     */
    private function assertCronKey(ServerRequestInterface $request): void
    {
        $submittedKey = $request->getHeader(self::HEADER__CRON_KEY);

        if (!$submittedKey) {
            throw new cronKeyException('Cron Key not submitted');
        }

        try {
            $cronKey = Singleton::getInstance()->app->cronKey;
        } catch (Exception $e) {
            throw new cronKeyException('Error fetching config');
        }

        if (!$cronKey) {
            throw new cronKeyException('App cron key not set');
        }

        if ($submittedKey[0] !== $cronKey) {
            throw new cronKeyException('Invalid cron key');
        }
    }
}
