<?php

namespace apexl\Io\modules\queue\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\System;
use apexl\Io\modules\queue\entities\queueItem;
use apexl\Io\modules\queue\dto\queueSettings\queueSettingsQueueDto;
use apexl\Io\modules\queue\services\queueItemsFinderService;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

class queueItemsController extends Controller
{
    private queueItemsFinderService $queueItemsFinderService;

    public function __construct(queueItemsFinderService $queueItemsFinderService)
    {
        parent::__construct();

        $this->queueItemsFinderService = $queueItemsFinderService;
    }

    public function active(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        return System::asJson($response, $this->queueItemsFinderService->items());
    }
}
