<?php

namespace apexl\Io\modules\queue\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\file\services\File;
use apexl\Io\modules\queue\dto\queueSettingsDto;
use apexl\Io\modules\queue\entities\queueItem;
use apexl\Io\modules\queue\exceptions\queueSettingsException;
use apexl\Io\modules\queueDisplay\forms\queueSettings;
use apexl\Io\services\Output;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

class queueSettingsController extends Controller
{
    private File $fileService;

    public function __construct(File $fileService)
    {
        parent::__construct();

        $this->fileService = $fileService;
    }

    public function update(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        try {
            $queueItemsDto = queueSettingsDto::fromRequest($request);

            foreach ($queueItemsDto->toArray() as $field => $value) {
                if ($value !== null) {
                    System::setVariable($field, $value);

                    continue;
                }

                System::deleteVariable($field);
            }

            Output::addMessage('settings.update.success', 'success', 'Settings updated');

            return System::asJson($response);
        } catch (queueSettingsException $e) {
            return $this->throw404($response);
        }
    }

    public function upload(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        $storedPath = $this->fileService::storeUploadedFile($request->getUploadedFiles()['file'], 'system', false);

        $file = $this->fileService::getFileFromUpload($request);
        $file->path = $storedPath;

        $file->store();


        return System::asJson($response, ['fid' => $file->id]);
    }
}
