<?php declare(strict_types=1);

namespace apexl\Io\modules\queue\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\System;
use apexl\Io\modules\queue\services\fulfilledCountService;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

class queueStatsController extends Controller
{
    private fulfilledCountService $fulfilledCountService;

    public function __construct(fulfilledCountService $fulfilledCountService)
    {
        parent::__construct();

        $this->fulfilledCountService = $fulfilledCountService;
    }

    public function count(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        return System::asJson($response, [
           'count' => $this->fulfilledCountService->count(),
        ]);
    }
}
