<?php

namespace apexl\Io\modules\queue\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\System;
use apexl\Io\modules\queue\entities\queueItem;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

class skipQueueController extends Controller
{
    public function skip(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        $uuid = $this->path->getRouteArg($request, 'uuid');
        if (!($queueItem = queueItem::fromUuid($uuid))) {
            $this->throw404($response);
            exit;
        }

        $queueItem->markSkipped();

        return System::asJson($response);
    }
}
