<?php declare(strict_types=1);

namespace apexl\Io\modules\queue\dto;

use Psr\Http\Message\ServerRequestInterface;
use Spatie\DataTransferObject\DataTransferObject;

class queueItemDto extends DataTransferObject
{
    public ?string $phone;
    public ?string $email;

    public static function fromRequest(ServerRequestInterface $request): queueItemDto
    {
        return new queueItemDto([
            'phone' => ($request->getParsedBody()->phone ?? null) ?: null,
            'email' => ($request->getParsedBody()->email ?? null) ?: null,
        ]);
    }
}
