<?php declare(strict_types=1);

namespace apexl\Io\modules\queue\dto\queueSettings;

use apexl\entityCore\enums\Casts;
use apexl\Io\includes\System;
use apexl\Io\modules\queue\dto\queueSettingsDto;
use apexl\Io\modules\queue\enums\CommunicationOptions;
use apexl\Io\modules\queueDisplay\forms\queueSettings;
use Psr\Http\Message\ServerRequestInterface;
use Spatie\DataTransferObject\DataTransferObjectError;

class queueSettingsJoinDto extends queueSettingsDto
{
    public const DEFAULT__PHONE = 'optional';
    public const DEFAULT__EMAIL = 'unused';
    public const DEFAULT__NOTIFY_SMS = true;
    public const DEFAULT__NOTIFY_EMAIL = true;
    public const DEFAULT__SMS_CONTENT = 'Come in number [POSITION], we\'re ready for you!';
    public const DEFAULT__EMAIL_CONTENT = 'Come in number [POSITION], we\'re ready for you!';
    public const DEFAULT__EMAIL_SUBJECT = 'Come in number [POSITION], we\'re ready for you!';

    public ?string $collect_phone;
    public ?string $collect_email;
    public ?bool $notify_sms;
    public ?bool $notify_email;
    public ?string $sms_content;
    public ?string $email_content;
    public ?string $email_subject;

    public function __construct(array $parameters = [], bool $withDefaults = false)
    {
        parent::__construct($parameters, $withDefaults);

        if ($this->collect_phone !== null && !CommunicationOptions::isValid($this->collect_phone)) {
            DataTransferObjectError::invalidTypes([
                DataTransferObjectError::invalidTypeMessage(
                    static::class,
                    queueSettings::FIELD__COLLECT_PHONE,
                    [CommunicationOptions::class],
                    $this->collect_phone
                ),
            ]);
        }

        if ($this->collect_email !== null && !CommunicationOptions::isValid($this->collect_email)) {
            DataTransferObjectError::invalidTypes([
                DataTransferObjectError::invalidTypeMessage(
                    static::class,
                    queueSettings::FIELD__COLLECT_EMAIL,
                    [CommunicationOptions::class],
                    $this->collect_email
                ),
            ]);
        }
    }

    public static function fromRequest(ServerRequestInterface $request): queueSettingsJoinDto
    {
        $data = $request->getParsedBody();

        return new queueSettingsJoinDto([
            queueSettings::FIELD__COLLECT_PHONE => $data->{queueSettings::FIELD__COLLECT_PHONE} ?: null,
            queueSettings::FIELD__COLLECT_EMAIL => $data->{queueSettings::FIELD__COLLECT_EMAIL} ?: null,
            queueSettings::FIELD__NOTIFY_SMS => $data->{queueSettings::FIELD__NOTIFY_SMS} ?: false,
            queueSettings::FIELD__NOTIFY_EMAIL => $data->{queueSettings::FIELD__NOTIFY_EMAIL} ?: false,
            queueSettings::FIELD__SMS_CONTENT => $data->{queueSettings::FIELD__SMS_CONTENT} ?: '',
            queueSettings::FIELD__EMAIL_CONTENT => $data->{queueSettings::FIELD__EMAIL_CONTENT} ?: '',
            queueSettings::FIELD__EMAIL_SUBJECT => $data->{queueSettings::FIELD__EMAIL_SUBJECT} ?: '',
        ]);
    }

    protected function normalizeValues(array $values, bool $withDefaults = false): array
    {
        $values[queueSettings::FIELD__COLLECT_PHONE] = self::normalizeValue(
            $values[queueSettings::FIELD__COLLECT_PHONE],
            Casts::STRING(),
            self::DEFAULT__PHONE,
            $withDefaults
        );

        $values[queueSettings::FIELD__COLLECT_EMAIL] = self::normalizeValue(
            $values[queueSettings::FIELD__COLLECT_EMAIL],
            Casts::STRING(),
            self::DEFAULT__EMAIL,
            $withDefaults
        );

        $values[queueSettings::FIELD__NOTIFY_SMS] = self::normalizeValue(
            $values[queueSettings::FIELD__NOTIFY_SMS],
            Casts::BOOL(),
            self::DEFAULT__NOTIFY_SMS,
            $withDefaults
        );

        $values[queueSettings::FIELD__NOTIFY_EMAIL] = self::normalizeValue(
            $values[queueSettings::FIELD__NOTIFY_EMAIL],
            Casts::BOOL(),
            self::DEFAULT__NOTIFY_EMAIL,
            $withDefaults
        );

        $values[queueSettings::FIELD__SMS_CONTENT] = self::normalizeValue(
            $values[queueSettings::FIELD__SMS_CONTENT],
            Casts::STRING(),
            self::DEFAULT__SMS_CONTENT,
            $withDefaults
        );

        $values[queueSettings::FIELD__EMAIL_SUBJECT] = self::normalizeValue(
            $values[queueSettings::FIELD__EMAIL_SUBJECT],
            Casts::STRING(),
            self::DEFAULT__EMAIL_SUBJECT,
            $withDefaults
        );

        $values[queueSettings::FIELD__EMAIL_CONTENT] = self::normalizeValue(
            $values[queueSettings::FIELD__EMAIL_CONTENT],
            Casts::STRING(),
            self::DEFAULT__EMAIL_CONTENT,
            $withDefaults
        );

        return $values;
    }

    public static function fromDb(bool $withDefaults = false): queueSettingsJoinDto
    {
        return new queueSettingsJoinDto([
            queueSettings::FIELD__COLLECT_PHONE => System::getVariable(
                    queueSettings::FIELD__COLLECT_PHONE
                ) ?? null,
            queueSettings::FIELD__COLLECT_EMAIL => System::getVariable(
                    queueSettings::FIELD__COLLECT_EMAIL
                ) ?? null,
            queueSettings::FIELD__NOTIFY_SMS => System::getVariable(
                    queueSettings::FIELD__NOTIFY_SMS
                ) ?? null,
            queueSettings::FIELD__NOTIFY_EMAIL => System::getVariable(
                    queueSettings::FIELD__NOTIFY_EMAIL
                ) ?? null,
            queueSettings::FIELD__SMS_CONTENT => System::getVariable(
                    queueSettings::FIELD__SMS_CONTENT
                ) ?: null,
            queueSettings::FIELD__EMAIL_SUBJECT => System::getVariable(
                    queueSettings::FIELD__EMAIL_SUBJECT
                ) ?: null,
            queueSettings::FIELD__EMAIL_CONTENT => System::getVariable(
                    queueSettings::FIELD__EMAIL_CONTENT
                ) ?: null,
        ], $withDefaults);
    }
}
