<?php declare(strict_types=1);

namespace apexl\Io\modules\queue\dto\queueSettings;

use apexl\entityCore\enums\Casts;
use apexl\Io\includes\System;
use apexl\Io\modules\queue\dto\queueSettingsDto;
use apexl\Io\modules\queueDisplay\forms\queueSettings;
use Psr\Http\Message\ServerRequestInterface;

class queueSettingsQueueDto extends queueSettingsDto
{
    public const DEFAULT__ACTIVE_TITLE = 'Currently serving';
    public const DEFAULT__UPCOMING_TITLE = 'Coming up...';
    public const DEFAULT__JOINED_TEMPLATE = 'You are number [POSITION] in the queue.';
    public const DEFAULT__WAITING_PERIOD = 15;
    public const DEFAULT__DISPLAY_UPCOMING = 10;
    public const DEFAULT__ACTIVE_COUNT = 1;

    public ?string $active_title;
    public ?string $upcoming_title;
    public ?string $joined_template;
    public ?int $waiting_period;
    public ?int $display_upcoming;
    public ?int $active_count;

    public static function fromRequest(ServerRequestInterface $request): queueSettingsQueueDto
    {
        $data = $request->getParsedBody();

        return new queueSettingsQueueDto([
            queueSettings::FIELD__ACTIVE_TITLE => $data->{queueSettings::FIELD__ACTIVE_TITLE} ?: null,

            queueSettings::FIELD__UPCOMING_TITLE => $data->{queueSettings::FIELD__UPCOMING_TITLE} ?: null,

            queueSettings::FIELD__JOINED_TEMPLATE => $data->{queueSettings::FIELD__JOINED_TEMPLATE} ?: null,

            queueSettings::FIELD__WAITING_PERIOD => $data->{queueSettings::FIELD__WAITING_PERIOD} !== '' ?
                $data->{queueSettings::FIELD__WAITING_PERIOD} : null,

            queueSettings::FIELD__DISPLAY_UPCOMING => $data->{queueSettings::FIELD__DISPLAY_UPCOMING} !== '' ?
                $data->{queueSettings::FIELD__DISPLAY_UPCOMING} : null,

            queueSettings::FIELD__ACTIVE_COUNT => $data->{queueSettings::FIELD__ACTIVE_COUNT} !== '' ?
                $data->{queueSettings::FIELD__ACTIVE_COUNT} : null,
        ]);
    }

    protected function normalizeValues(array $values, bool $withDefaults = false): array
    {
        $values[queueSettings::FIELD__ACTIVE_TITLE] = self::normalizeValue(
            $values[queueSettings::FIELD__ACTIVE_TITLE],
            Casts::STRING(),
            self::DEFAULT__ACTIVE_TITLE,
            $withDefaults
        );

        $values[queueSettings::FIELD__UPCOMING_TITLE] = self::normalizeValue(
            $values[queueSettings::FIELD__UPCOMING_TITLE],
            Casts::STRING(),
            self::DEFAULT__UPCOMING_TITLE,
            $withDefaults
        );

        $values[queueSettings::FIELD__JOINED_TEMPLATE] = self::normalizeValue(
            $values[queueSettings::FIELD__JOINED_TEMPLATE],
            Casts::STRING(),
            self::DEFAULT__JOINED_TEMPLATE,
            $withDefaults
        );

        $values[queueSettings::FIELD__WAITING_PERIOD] = self::normalizeValue(
            $values[queueSettings::FIELD__WAITING_PERIOD],
            Casts::INT(),
            self::DEFAULT__WAITING_PERIOD,
            $withDefaults
        );

        $values[queueSettings::FIELD__DISPLAY_UPCOMING] = self::normalizeValue(
            $values[queueSettings::FIELD__DISPLAY_UPCOMING],
            Casts::INT(),
            self::DEFAULT__DISPLAY_UPCOMING,
            $withDefaults
        );

        $values[queueSettings::FIELD__ACTIVE_COUNT] = self::normalizeValue(
            $values[queueSettings::FIELD__ACTIVE_COUNT],
            Casts::INT(),
            self::DEFAULT__ACTIVE_COUNT,
            $withDefaults
        );

        return $values;
    }

    public static function fromDb(bool $withDefaults = false): queueSettingsQueueDto
    {
        return new queueSettingsQueueDto([
            queueSettings::FIELD__ACTIVE_TITLE => System::getVariable(
                    queueSettings::FIELD__ACTIVE_TITLE
                ) ?? null,

            queueSettings::FIELD__UPCOMING_TITLE => System::getVariable(
                    queueSettings::FIELD__UPCOMING_TITLE
                ) ?? null,

            queueSettings::FIELD__JOINED_TEMPLATE => System::getVariable(
                    queueSettings::FIELD__JOINED_TEMPLATE
                ) ?? null,

            queueSettings::FIELD__WAITING_PERIOD => System::getVariable(
                    queueSettings::FIELD__WAITING_PERIOD
                ) ?? null,

            queueSettings::FIELD__DISPLAY_UPCOMING => System::getVariable(
                    queueSettings::FIELD__DISPLAY_UPCOMING
                ) ?? null,

            queueSettings::FIELD__ACTIVE_COUNT => System::getVariable(
                    queueSettings::FIELD__ACTIVE_COUNT
                ) ?? null,

        ], $withDefaults);
    }
}
