<?php declare(strict_types=1);

namespace apexl\Io\modules\queue\dto\queueSettings;

use apexl\entityCore\enums\Casts;
use apexl\Io\includes\System;
use apexl\Io\modules\queue\dto\queueSettingsDto;
use apexl\Io\modules\queueDisplay\forms\queueSettings;
use Psr\Http\Message\ServerRequestInterface;

class queueSettingsStatsDto extends queueSettingsDto
{
    public const DEFAULT__ADDITION_TOTAL = 0;
    public const DEFAULT__STATS_VIDEO = null;
    public const DEFAULT__STATS_LEAD = '<p>Amended Count is [COUNT]</p>';

    public ?int $addition_total;
    public ?int $stats_video;
    public ?string $stats_lead;

    public static function fromRequest(ServerRequestInterface $request): queueSettingsStatsDto
    {
        $data = $request->getParsedBody();

        return new queueSettingsStatsDto([
            queueSettings::FIELD__STATS_LEAD => $data->{queueSettings::FIELD__STATS_LEAD} ?: null,

            queueSettings::FIELD__STATS_VIDEO => $data->{queueSettings::FIELD__STATS_VIDEO} !== '' ?
                $data->{queueSettings::FIELD__STATS_VIDEO} : null,

            queueSettings::FIELD__ADDITION_TOTAL => $data->{queueSettings::FIELD__ADDITION_TOTAL} !== '' ?
                $data->{queueSettings::FIELD__ADDITION_TOTAL} : null,
        ]);
    }

    protected function normalizeValues(array $values, bool $withDefaults = false): array
    {
        $values[queueSettings::FIELD__ADDITION_TOTAL] = self::normalizeValue(
            $values[queueSettings::FIELD__ADDITION_TOTAL],
            Casts::INT(),
            self::DEFAULT__ADDITION_TOTAL,
            $withDefaults
        );

        $values[queueSettings::FIELD__STATS_LEAD] = self::normalizeValue(
            $values[queueSettings::FIELD__STATS_LEAD],
            Casts::STRING(),
            self::DEFAULT__STATS_LEAD,
            $withDefaults
        );

        $values[queueSettings::FIELD__STATS_VIDEO] = self::normalizeValue(
            $values[queueSettings::FIELD__STATS_VIDEO],
            Casts::INT(),
            self::DEFAULT__STATS_VIDEO,
            $withDefaults
        );

        return $values;
    }

    public static function fromDb(bool $withDefaults = false): queueSettingsStatsDto
    {
        return new queueSettingsStatsDto([
            queueSettings::FIELD__ADDITION_TOTAL => System::getVariable(
                    queueSettings::FIELD__ADDITION_TOTAL
                ) ?? null,

            queueSettings::FIELD__STATS_LEAD => System::getVariable(
                    queueSettings::FIELD__STATS_LEAD
                ) ?? null,

            queueSettings::FIELD__STATS_VIDEO => System::getVariable(
                    queueSettings::FIELD__STATS_VIDEO
                ) ?? null,
        ]);
    }
}
