<?php declare(strict_types=1);

namespace apexl\Io\modules\queue\dto;

use apexl\entityCore\enums\Casts;
use apexl\Io\modules\queue\dto\queueSettings\queueSettingsJoinDto;
use apexl\Io\modules\queue\dto\queueSettings\queueSettingsStatsDto;
use apexl\Io\modules\queue\exceptions\queueSettingsException;
use apexl\Io\modules\queueDisplay\forms\queueSettings;
use apexl\Io\modules\queue\dto\queueSettings\queueSettingsQueueDto;
use Psr\Http\Message\ServerRequestInterface;
use Spatie\DataTransferObject\DataTransferObject;

abstract class queueSettingsDto extends DataTransferObject
{
    abstract protected function normalizeValues(array $values, bool $withDefaults = false): array;

    public function __construct(array $parameters = [], bool $withDefaults = false)
    {
        parent::__construct($this->normalizeValues($parameters, $withDefaults));
    }

    /**
     * @throws queueSettingsException
     */
    public static function fromRequest(ServerRequestInterface $request): queueSettingsDto
    {
        $data = $request->getParsedBody();

        switch ($data->page) {
            case queueSettings\queuePageSettings::PAGE:
                return queueSettingsQueueDto::fromRequest($request);

            case queueSettings\statsPageSettings::PAGE:
                return queueSettingsStatsDto::fromRequest($request);

            case queueSettings\joinPageSettings::PAGE:
                return queueSettingsJoinDto::fromRequest($request);

            default:
                throw new queueSettingsException('Invalid page');
        }
    }

    protected static function normalizeValue(
        $value,
        Casts $cast,
        $default,
        bool $withDefaults
    ) {
        if ($value !== null) {
            settype($value, $cast->getValue());

            return $value;
        }

        return $withDefaults ? $default : null;
    }
}
