<?php declare(strict_types=1);

namespace apexl\Io\modules\queue\helpers;

class Condition
{
    public static function isNull(string $column): array
    {
        return [$column, null, 'IS'];
    }

    public static function notNull(string $column): array
    {
        return [$column, null, 'IS NOT'];
    }

    public static function equals(string $column, $value): array
    {
        return [$column, $value, '='];
    }

    public static function notEquals(string $column, $value): array
    {
        return [$column, $value, '!='];
    }

    public static function in(string $column, array $in): array
    {
        return [$column, $in, 'IN'];
    }

    public static function notIn(string $column, array $in): array
    {
        return [$column, $in, 'NOT IN'];
    }

    public static function greaterThan(string $column, int $than): array
    {
        return [$column, $than, '>'];
    }

    public static function lessThan(string $column, int $than): array
    {
        return [$column, $than, '<'];
    }

    public static function greaterThanOrEqual(string $column, $than): array
    {
        return [$column, $than, '>='];
    }

    public static function lessThanOrEqual(string $column, $than): array
    {
        return [$column, $than, '<='];
    }
}
