<?php declare(strict_types=1);

namespace apexl\Io\modules\queue\listeners;

use apexl\Io\includes\Hook;
use apexl\Io\modules\queue\entities\queueItem;

class getEntityDataListener
{
    private const HOOK = 'getEntityData';

    const ALLOWED = [
        'position',
        'phone',
        'fulfilled_at',
        'skipped_at'
    ];

    public static function register()
    {
        Hook::registerCallback(
            self::HOOK,
            sprintf('%s:handle', getEntityDataListener::class)
        );
    }
    public static function handle(array $data, string $entityName): array
    {
        if ($entityName === (new queueItem())->getEntityName()) {
            $data['tableHeader'] = self::filterAllowedFields($data['tableHeader']);

            $data['rows'] = array_map(
                [self::class, 'filterAllowedFields'],
                $data['rows'],
            );
        }

        return $data;
    }

    private static function filterAllowedFields(array $fields): array
    {
        return array_filter(
            $fields,
            [self::class, 'isAllowedField'],
            ARRAY_FILTER_USE_KEY
        );
    }

    private static function isAllowedField($key): bool
    {
        return in_array($key, self::ALLOWED);
    }
}
