<?php declare(strict_types=1);

namespace apexl\Io\modules\queue\listeners;

use apexl\Io\includes\Hook;
use apexl\Io\modules\queue\entities\queueItem;
use apexl\Io\modules\queue\jobs\notifyLatest;

class postEntityUpdateListener
{
    private const HOOK = 'postEntityUpdate';

    public static function register()
    {
        Hook::registerCallback(
            self::HOOK,
            sprintf('%s:handle', postEntityUpdateListener::class)
        );

    }
    public static function handle(array $data, string $table): array
    {
        if ($table === queueItem::TABLE) {
            (new notifyLatest())->handle();
        }

        return $data;
    }
}
