<?php declare(strict_types=1);

namespace apexl\Io\modules\queue\notifiers;

use apexl\Io\modules\notifier\interfaces\emailNotifierDriverInterface;
use apexl\Io\modules\notifier\notifiers\emailNotifier;
use apexl\Io\modules\queue\dto\queueSettings\queueSettingsJoinDto;
use apexl\Io\modules\queue\entities\queueItem;
use apexl\Io\modules\queue\interfaces\queueItemReadyNotifierInterface;

class queueItemReadyEmailNotifier extends emailNotifier implements queueItemReadyNotifierInterface
{
    private queueItem $queueItem;
    private queueSettingsJoinDto $settings;

    public function __construct(emailNotifierDriverInterface $driver, queueItem $queueItem)
    {
        parent::__construct($driver);
        $this->settings = queueSettingsJoinDto::fromDb(true);

        $this->queueItem = $queueItem;
    }

    protected function to(): string
    {
        return $this->queueItem->email;
    }

    protected function subject(): string
    {
        return sprintf($this->settings->email_subject, $this->queueItem->position);
    }

    protected function body(): string
    {
        return sprintf($this->settings->email_content, $this->queueItem->position);
    }

    protected function shouldSend(): bool
    {
        return $this->settings->notify_email && !!$this->queueItem->email;
    }
}
