<?php declare(strict_types=1);

namespace apexl\Io\modules\queue\notifiers;

use apexl\Io\modules\logger\notifiers\loggerNotifier;
use apexl\Io\modules\queue\entities\queueItem;
use apexl\Io\modules\queue\interfaces\queueItemReadyNotifierInterface;

class queueItemReadyLoggerNotifier extends loggerNotifier implements queueItemReadyNotifierInterface
{
    private queueItem $queueItem;

    public function __construct(queueItem $queueItem)
    {
        parent::__construct();

        $this->queueItem = $queueItem;
    }

    protected function message(): string
    {
        return sprintf('Come in number %d, we\'re ready for you!', $this->queueItem->position);
    }

    protected function context(): array
    {
        return $this->queueItem->getData(false);
    }
}
