<?php declare(strict_types=1);

namespace apexl\Io\modules\queue\notifiers;

use apexl\Io\modules\notifier\interfaces\smsNotifierDriverInterface;
use apexl\Io\modules\notifier\notifiers\smsNotifier;
use apexl\Io\modules\queue\dto\queueSettings\queueSettingsJoinDto;
use apexl\Io\modules\queue\entities\queueItem;
use apexl\Io\modules\queue\interfaces\queueItemReadyNotifierInterface;
use apexl\Io\modules\queueDisplay\forms\queueSettings\joinPageSettings;

class queueItemReadySmsNotifier extends smsNotifier implements queueItemReadyNotifierInterface
{
    private queueItem $queueItem;
    private queueSettingsJoinDto $settings;

    public function __construct(smsNotifierDriverInterface $driver, queueItem $queueItem)
    {
        parent::__construct($driver);
        $this->settings = queueSettingsJoinDto::fromDb(true);

        $this->queueItem = $queueItem;
    }

    protected function to(): string
    {
        return $this->queueItem->phone;
    }

    protected function body(): string
    {
        return sprintf(str_replace(
            '[POSITION]',
            '%d',
            $this->settings->sms_content
        ), $this->queueItem->position);
    }

    protected function shouldSend(): bool
    {
        return $this->settings->notify_sms && !!$this->queueItem->phone;
    }
}
