<?php declare(strict_types=1);

namespace apexl\Io\modules\queue\operators;

use apexl\Io\modules\queue\helpers\Condition;
use apexl\Io\operators\entityDatabaseOperator;

class queueItemOperator extends entityDatabaseOperator
{
    public function uuidExists(string $uuid): bool
    {
        $result = $this->vault->select($this->dbTable)
            ->fields(['count(*) as count'])
            ->where('uuid', $uuid)
            ->execute()
            ->fetchAssoc();

        return ((int) $result['count']) !== 0;
    }

    public function fulfilledCount(): int
    {
        $result = $this->vault->select($this->dbTable)
            ->fields(['count(*) as count'])
            ->where(...Condition::notNull('fulfilled_at'))
            ->execute()
            ->fetchAssoc();

        return (int) $result['count'];
    }
}
