<?php declare(strict_types=1);

namespace apexl\Io\modules\queue\services;

use apexl\Io\modules\queue\dto\queueSettings\queueSettingsStatsDto;
use apexl\Io\modules\queue\entities\queueItem;

class fulfilledCountService
{
    private queueSettingsStatsDto $settings;

    public function __construct()
    {
        $this->settings = queueSettingsStatsDto::fromDb(true);
    }

    public function count(): string
    {
        $total = (new queueItem())->fulfilledCount();

        return number_format($total + ($this->settings->addition_total ?? 0));

    }
}
