<?php declare(strict_types=1);

namespace apexl\Io\modules\queueDisplay\components;

use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\queue\dto\queueSettingsDto;
use apexl\Io\modules\queue\entities\queueItem;
use apexl\Io\modules\queue\queueModule;
use apexl\Io\modules\queue\dto\queueSettings\queueSettingsQueueDto;
use apexl\Io\modules\user\services\currentUser;
use Exception;

class queueComponent extends componentEntity
{
    private const PROP__QUEUE_ITEMS = 'queueItems';
    private const PROP__ADMIN = 'admin';
    private const PROP__ACTIVE_TITLE = 'activeTitle';
    private const PROP__ACTIVE_COUNT = 'activeCount';
    private const PROP__WAITING_COUNT = 'waitingCount';
    private const PROP__UPCOMING_TITLE = 'upcomingTitle';

    /**
     * @param  queueItem[]  $queueItems
     */
    public function __construct(array $queueItems)
    {
        $settings = queueSettingsQueueDto::fromDb(true);

        try {
            parent::__construct();

            $this
                ->setQueueItems($queueItems)
                ->setAdmin($this->isAdmin())
                ->setActiveTitle($settings->active_title)
                ->setUpcomingTitle($settings->upcoming_title)
                ->setActiveCount($settings->active_count)
                ->setWaitingCount($settings->display_upcoming);

        } catch (Exception $e) {
            user_error($e->getMessage(), E_USER_ERROR);
        }

    }

    /**
     * @param queueItem[] $queueItems
     */
    private function setQueueItems(array $queueItems): queueComponent
    {
        $this->addProperty(self::PROP__QUEUE_ITEMS, $queueItems);

        return $this;
    }

    private function isAdmin(): bool
    {
        $user = currentUser::getCurrentUser();

        return $user->isAllowed(queueModule::PERMISSION__MANAGE_QUEUE);
    }

    private function setAdmin(bool $admin): queueComponent
    {
        $this->addProperty(self::PROP__ADMIN, $admin);

        return $this;
    }

    private function setActiveTitle(string $title): queueComponent
    {
        $this->addProperty(self::PROP__ACTIVE_TITLE, $title);

        return $this;
    }

    private function setActiveCount(int $count): queueComponent
    {
        $this->addProperty(self::PROP__ACTIVE_COUNT, $count);

        return $this;
    }

    private function setWaitingCount(int $count): queueComponent
    {
        $this->addProperty(self::PROP__WAITING_COUNT, $count);

        return $this;
    }

    private function setUpcomingTitle(string $title): queueComponent
    {
        $this->addProperty(self::PROP__UPCOMING_TITLE, $title);

        return $this;
    }
}
