<?php declare(strict_types=1);

namespace apexl\Io\modules\queueDisplay\components;

use apexl\Config\Singleton;
use apexl\Io\includes\Routes;
use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\file\entities\fileEntity;
use apexl\Io\modules\queue\dto\queueSettings\queueSettingsStatsDto;
use apexl\Io\modules\queue\services\fulfilledCountService;
use Exception;

class statsComponent extends componentEntity
{
    private const PROP__TEMPLATE = 'template';
    private const PROP__COUNT = 'count';
    private const PROP__ROUTE_REFRESH = 'route_refresh';
    private const PROP__VIDEO = 'video_src';

    private fulfilledCountService $fulfilledCountService;

    public function __construct(fulfilledCountService $fulfilledCountService)
    {
        $this->fulfilledCountService = $fulfilledCountService;
        $settings = queueSettingsStatsDto::fromDb(true);

        try {
            parent::__construct();

            $video = new fileEntity();
            $video->load($settings->stats_video);

            $this
                ->setTemplate(nl2br($settings->stats_lead))
                ->setCount($this->fulfilledCountService->count())
                ->setVideoSrc(sprintf(
                    '%s/%s',
                    Singleton::getInstance()->app->site->backend_domain,
                    $video->downloadFilePath()
                ))
                ->setRefreshRoute(Routes::getRoutePattern('queue.stats.count'));
        } catch (Exception $e) {
            logger()->error($e->getMessage());
            exit;
        }
    }

    private function setTemplate(string $template): statsComponent
    {
        return $this->addProperty(self::PROP__TEMPLATE, $template);
    }

    private function setVideoSrc(string $src): statsComponent
    {
        return $this->addProperty(self::PROP__VIDEO, $src);
    }

    private function setCount(string $count): statsComponent
    {
        return $this->addProperty(self::PROP__COUNT, $count);
    }

    private function setRefreshRoute(string $route): statsComponent
    {
        return $this->addProperty(self::PROP__ROUTE_REFRESH, $route);
    }

}
