<?php declare(strict_types=1);

namespace apexl\Io\modules\queueDisplay\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\System;
use apexl\Io\modules\display\services\Render;
use apexl\Io\modules\queue\entities\queueItem;
use apexl\Io\modules\queue\services\queueItemsFinderService;
use apexl\Io\modules\queueDisplay\components\queueComponent;
use apexl\Io\modules\queueDisplay\pages\noUiNoLogo;
use apexl\Io\services\Output;
use app\module\cokeQueue\components\decorationComponent;
use app\module\cokeQueue\enums\decorationIcon;
use app\module\cokeQueue\enums\decorationPosition;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

class displayQueueDisplayController extends Controller
{
    private queueItemsFinderService $queueItemsFinderService;

    public function __construct(queueItemsFinderService $queueItemsFinderService)
    {
        parent::__construct();

        $this->queueItemsFinderService = $queueItemsFinderService;
    }

    public function display(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        Render::setActive(noUiNoLogo::class);

        Output::addResponse($request, Render::build([
            new queueComponent($this->queueItemsFinderService->items()),
            (new decorationComponent())->setPosition(decorationPosition::TOP())->setIcons([
                decorationIcon::BAUBLE_6(),
                decorationIcon::SNOWFLAKE_1(),
                decorationIcon::SNOWFLAKE_14(),
                decorationIcon::BAUBLE_5(),
                decorationIcon::SNOWFLAKE_7(),
                decorationIcon::SNOWFLAKE_2(),
                decorationIcon::BAUBLE_3(),
                decorationIcon::SNOWFLAKE_12(),
                decorationIcon::SNOWFLAKE_11(),
                decorationIcon::BAUBLE_8(),
            ]),
            (new decorationComponent())->setPosition(decorationPosition::BOTTOM())->setIcons([
                decorationIcon::CANDLE_2(),
                decorationIcon::GLASS(),
                decorationIcon::CAKE(),
                decorationIcon::SNOWGLOBE(),
                decorationIcon::SANTA(),
                decorationIcon::PRESENT(),
                decorationIcon::BOTTLES(),
                decorationIcon::DUTCHOVEN_1(),
                decorationIcon::PUDDING(),
                decorationIcon::FRUIT(),
                decorationIcon::DUTCHOVEN_3(),
                decorationIcon::CANDLE_1(),
                decorationIcon::STAR(),
                decorationIcon::BOWL_1(),
                decorationIcon::ICE_CREAM_1(),
            ]),

        ]));

        return System::asJson($response);
    }
}
