<?php declare(strict_types=1);

namespace apexl\Io\modules\queueDisplay\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\display\components\ContentTitle;
use apexl\Io\modules\display\components\FormComponent;
use apexl\Io\modules\display\services\Render;
use apexl\Io\modules\queue\dto\queueSettings\queueSettingsJoinDto;
use apexl\Io\modules\queue\entities\queueItem;
use apexl\Io\modules\queueDisplay\forms\joinQueue;
use apexl\Io\modules\queue\dto\queueSettings\queueSettingsQueueDto;
use apexl\Io\modules\queueDisplay\pages\noUiNoLogo;
use apexl\Io\services\Output;
use apexl\Utils\Strings\Phone;
use app\module\cokeQueue\components\decorationComponent;
use app\module\cokeQueue\enums\decorationIcon;
use app\module\cokeQueue\enums\decorationPosition;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

class joinQueueDisplayController extends Controller
{
    private joinQueue $joinQueue;

    public function __construct(joinQueue $joinQueue)
    {
        parent::__construct();

        $this->joinQueue = $joinQueue;
    }

    public function join(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        Render::setActive(noUiNoLogo::class);

        Output::addResponse($request, Render::build([
            (new FormComponent())
                ->setID('join-queue')
                ->src(Routes::getRoutePattern('queue.display.join.form')),
            (new decorationComponent())->setPosition(decorationPosition::TOP())->setIcons([
                decorationIcon::BAUBLE_5(),
                decorationIcon::SNOWFLAKE_12(),
                decorationIcon::SNOWFLAKE_14(),
                decorationIcon::BAUBLE_3(),
                decorationIcon::SNOWFLAKE_2(),
                decorationIcon::SNOWFLAKE_7(),
                decorationIcon::BAUBLE_6(),
                decorationIcon::SNOWFLAKE_1(),
                decorationIcon::SNOWFLAKE_11(),
                decorationIcon::BAUBLE_8(),
            ]),
            (new decorationComponent())->setPosition(decorationPosition::BOTTOM())->setIcons([
                decorationIcon::ICE_CREAM_1(),
                decorationIcon::CANDLE_1(),
                decorationIcon::CAKE(),
                decorationIcon::PUDDING(),
                decorationIcon::FRUIT(),
                decorationIcon::DUTCHOVEN_1(),
                decorationIcon::BOTTLES(),
                decorationIcon::GLASS(),
                decorationIcon::SANTA(),
                decorationIcon::BOWL_1(),
                decorationIcon::CANDLE_2(),
                decorationIcon::PRESENT(),
                decorationIcon::DUTCHOVEN_3(),
                decorationIcon::STAR(),
                decorationIcon::SNOWGLOBE(),
            ]),
        ]));

        return System::asJson($response);
    }

    /** @noinspection PhpUnusedParameterInspection */
    public function form(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        return System::asJson($response, $this->joinQueue->form([
            'action' => Routes::getRoutePattern('queue.join')
        ])->getBuiltFormArray());
    }


    public function joined(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        Render::setActive(noUiNoLogo::class);

        $queueSettings = queueSettingsQueueDto::fromDb(true);
        $joinSettings = queueSettingsJoinDto::fromDb(true);

        $queueItem = queueItem::fromUuid($this->path->getRouteArg($request,'uuid'));

        $components = [
            (new ContentTitle())->addTitle(
                sprintf(
                    str_replace('[POSITION]', '%d', $queueSettings->joined_template),
                    $queueItem->position
                )
            ),
            (new decorationComponent())->setPosition(decorationPosition::TOP())->setIcons([
                decorationIcon::BAUBLE_1(),
                decorationIcon::SNOWFLAKE_5(),
                decorationIcon::SNOWFLAKE_6(),
                decorationIcon::BAUBLE_6(),
                decorationIcon::SNOWFLAKE_10(),
                decorationIcon::SNOWFLAKE_9(),
                decorationIcon::BAUBLE_7(),
                decorationIcon::SNOWFLAKE_8(),
                decorationIcon::SNOWFLAKE_4(),
                decorationIcon::BAUBLE_4(),
            ]),
            (new decorationComponent())->setPosition(decorationPosition::BOTTOM())->setIcons([
                decorationIcon::SNOWGLOBE(),
                decorationIcon::STAR(),
                decorationIcon::DUTCHOVEN_3(),
                decorationIcon::PRESENT(),
                decorationIcon::CANDLE_2(),
                decorationIcon::SANTA(),
                decorationIcon::GLASS(),
                decorationIcon::BOTTLES(),
                decorationIcon::BOWL_1(),
                decorationIcon::CAKE(),
                decorationIcon::DUTCHOVEN_1(),
                decorationIcon::ICE_CREAM_1(),
                decorationIcon::FRUIT(),
                decorationIcon::PUDDING(),
                decorationIcon::CANDLE_1(),
            ])
        ];

        if ($joinSettings->notify_sms && $queueItem->phone) {
            $components[] = (new ContentTitle())->addContent(
                sprintf(
                    'We will send a message to %s when it is your turn.',
                    Phone::stripCountryCode($queueItem->phone)
                )
            );
        }

        if ($joinSettings->notify_email && $queueItem->email) {
            $components[] = (new ContentTitle())->addContent(
                sprintf(
                    'We will send a message to %s when it is your turn.',
                    $queueItem->email
                )
            );
        }

        Output::addResponse($request, Render::build($components));

        return System::asJson($response);
    }
}
