<?php

namespace apexl\Io\modules\queueDisplay\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\display\components\FormComponent;
use apexl\Io\modules\display\services\Render;
use apexl\Io\modules\queue\enums\SettingsForm;
use apexl\Io\modules\queueDisplay\forms\queueSettings\joinPageSettings;
use apexl\Io\modules\queueDisplay\forms\queueSettings\queuePageSettings;
use apexl\Io\modules\queueDisplay\forms\queueSettings;
use apexl\Io\modules\queueDisplay\forms\queueSettings\statsPageSettings;
use apexl\Io\services\Output;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

class queueSettingsDisplayController extends Controller
{
    /**
     * @var queueSettings[]
     */
    private array $forms = [];

    public function __construct(
        queuePageSettings $queuePageSettings,
        statsPageSettings $statsPageSettings,
        joinPageSettings $joinPageSettings
    ) {
        parent::__construct();

        $this->forms[SettingsForm::QUEUE()->getValue()] = $queuePageSettings;
        $this->forms[SettingsForm::STATS()->getValue()] = $statsPageSettings;
        $this->forms[SettingsForm::JOIN()->getValue()] = $joinPageSettings;
    }

    public function queue(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        Render::setPageTitle('Queue Settings');

        Output::addResponse($request, Render::build([
            (new FormComponent())
                ->setID('queue-settings--queue')
                ->src($this->formRoute(SettingsForm::QUEUE()))
        ]));

        return System::asJson($response);
    }

    public function stats(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        Render::setPageTitle('Stats Settings');

        Output::addResponse($request, Render::build([
            (new FormComponent())
                ->setID('queue-settings--stats')
                ->src($this->formRoute(SettingsForm::STATS()))
        ]));

        return System::asJson($response);
    }

    public function join(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        Render::setPageTitle('Join page Settings');

        Output::addResponse($request, Render::build([
            (new FormComponent())
                ->setID('queue-settings--join')
                ->src($this->formRoute(SettingsForm::JOIN()))
        ]));

        return System::asJson($response);
    }

    private function formRoute(SettingsForm $settingsForm): string
    {
        return Routes::getRoutePattern('queue.settings.form', [
            'form' => $settingsForm->getValue(),
        ]);
    }

    public function form(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {

        $form = $this->path->getRouteArg($request, 'form');
        $queueSettings = $this->forms[$this->path->getRouteArg($request, 'form')] ?? null;

        if (!SettingsForm::isValid($form) || !$queueSettings) {
            $this->throw404($response);
        }

        return System::asJson($response, $queueSettings->form()->getBuiltFormArray());
    }
}
